/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.members.cssclass.annotprop;

import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.commons.internal.collections._Maps;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.ContributeeMemberFacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.core.metamodel.facets.members.cssclass.CssClassFacet;
import org.apache.isis.core.metamodel.facets.members.cssclass.annotprop.CssClassFacetOnActionFromConfiguredRegex;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectMember;

public class CssClassFacetOnActionFromConfiguredRegexFactory
extends FacetFactoryAbstract
implements ContributeeMemberFacetFactory {
    private static final Pattern CSS_CLASS_REGEX_PATTERN = Pattern.compile("([^:]+):(.+)");
    private Map<Pattern, String> cssClassByPattern;

    public CssClassFacetOnActionFromConfiguredRegexFactory() {
        super(FeatureType.ACTIONS_ONLY);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        FacetedMethod facetHolder = (FacetedMethod)processMethodContext.getFacetHolder();
        if (facetHolder.containsDoOpFacet(CssClassFacet.class)) {
            return;
        }
        Method method = processMethodContext.getMethod();
        String name = method.getName();
        Class<?> owningType = facetHolder.getOwningType();
        if (this.servicesInjector.isService(owningType)) {
            return;
        }
        CssClassFacet cssClassFacet = this.createFromConfiguredRegexIfPossible(name, facetHolder);
        FacetUtil.addFacet(cssClassFacet);
    }

    @Override
    public void process(ContributeeMemberFacetFactory.ProcessContributeeMemberContext processMemberContext) {
        ObjectMember objectMember = (ObjectMember)processMemberContext.getFacetHolder();
        if (!(objectMember instanceof ObjectAction)) {
            return;
        }
        if (objectMember.containsDoOpFacet(CssClassFacet.class)) {
            return;
        }
        String id = objectMember.getId();
        CssClassFacet cssClassFacet = this.createFromConfiguredRegexIfPossible(id, objectMember);
        FacetUtil.addFacet(cssClassFacet);
    }

    private CssClassFacet createFromConfiguredRegexIfPossible(String name, FacetHolder facetHolder) {
        String value = this.cssIfAnyFor(name);
        return value != null ? new CssClassFacetOnActionFromConfiguredRegex(value, facetHolder) : null;
    }

    private String cssIfAnyFor(String name) {
        Map<Pattern, String> cssClassByPattern = this.getCssClassByPattern();
        for (Map.Entry<Pattern, String> entry : cssClassByPattern.entrySet()) {
            Pattern pattern = entry.getKey();
            String cssClass = entry.getValue();
            if (!pattern.matcher(name).matches()) continue;
            return cssClass;
        }
        return null;
    }

    private Map<Pattern, String> getCssClassByPattern() {
        if (this.cssClassByPattern == null) {
            String cssClassPatterns = this.getConfiguration().getString("isis.reflector.facet.cssClass.patterns");
            this.cssClassByPattern = CssClassFacetOnActionFromConfiguredRegexFactory.buildCssClassByPattern(cssClassPatterns);
        }
        return this.cssClassByPattern;
    }

    private static Map<Pattern, String> buildCssClassByPattern(String cssClassPatterns) {
        LinkedHashMap cssClassByPattern = _Maps.newLinkedHashMap();
        if (cssClassPatterns != null) {
            StringTokenizer regexToCssClasses = new StringTokenizer(cssClassPatterns, ",");
            LinkedHashMap cssClassByRegex = _Maps.newLinkedHashMap();
            while (regexToCssClasses.hasMoreTokens()) {
                Matcher matcher;
                String regexToCssClass = regexToCssClasses.nextToken().trim();
                if (_Strings.isNullOrEmpty((CharSequence)regexToCssClass) || !(matcher = CSS_CLASS_REGEX_PATTERN.matcher(regexToCssClass)).matches()) continue;
                cssClassByRegex.put(matcher.group(1), matcher.group(2));
            }
            for (Map.Entry entry : cssClassByRegex.entrySet()) {
                String regex = (String)entry.getKey();
                String cssClass = (String)entry.getValue();
                cssClassByPattern.put(Pattern.compile(regex), cssClass);
            }
        }
        return cssClassByPattern;
    }
}

