/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.fallback;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.isis.applib.annotation.LabelPosition;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.core.commons.lang.StringExtensions;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.core.metamodel.facets.TypedHolder;
import org.apache.isis.core.metamodel.facets.fallback.ActionChoicesFacetNone;
import org.apache.isis.core.metamodel.facets.fallback.ActionDefaultsFacetNone;
import org.apache.isis.core.metamodel.facets.fallback.DescribedAsFacetNone;
import org.apache.isis.core.metamodel.facets.fallback.HelpFacetNone;
import org.apache.isis.core.metamodel.facets.fallback.LabelAtFacetFromLayoutConfiguration;
import org.apache.isis.core.metamodel.facets.fallback.MaxLengthFacetUnlimited;
import org.apache.isis.core.metamodel.facets.fallback.MultiLineFacetNone;
import org.apache.isis.core.metamodel.facets.fallback.NamedFacetDefault;
import org.apache.isis.core.metamodel.facets.fallback.NamedFacetNone;
import org.apache.isis.core.metamodel.facets.fallback.PagedFacetFromConfiguration;
import org.apache.isis.core.metamodel.facets.fallback.TitleFacetNone;

public class FallbackFacetFactory
extends FacetFactoryAbstract {
    public static final int PAGE_SIZE_STANDALONE_DEFAULT = 25;
    public static final int PAGE_SIZE_PARENTED_DEFAULT = 12;
    private static final Map<Class<?>, Integer> TYPICAL_LENGTHS_BY_CLASS = new HashMap<Class<?>, Integer>(){
        private static final long serialVersionUID = 1L;
        {
            this.putTypicalLength(Byte.TYPE, Byte.class, 3);
            this.putTypicalLength(Short.TYPE, Short.class, 5);
            this.putTypicalLength(Integer.TYPE, Integer.class, 10);
            this.putTypicalLength(Long.TYPE, Long.class, 20);
            this.putTypicalLength(Float.TYPE, Float.class, 20);
            this.putTypicalLength(Double.TYPE, Double.class, 20);
            this.putTypicalLength(Character.TYPE, Character.class, 1);
            this.putTypicalLength(Boolean.TYPE, Boolean.class, 1);
        }

        private void putTypicalLength(Class<?> primitiveClass, Class<?> wrapperClass, int length) {
            this.put(primitiveClass, length);
            this.put(wrapperClass, length);
        }
    };

    public FallbackFacetFactory() {
        super(FeatureType.EVERYTHING);
    }

    @Override
    public void process(FacetFactory.ProcessClassContext processClassContext) {
        Object facetHolder = processClassContext.getFacetHolder();
        DescribedAsFacetNone describedAsFacet = new DescribedAsFacetNone((FacetHolder)facetHolder);
        TitleFacetNone titleFacet = new TitleFacetNone((FacetHolder)facetHolder);
        int pagedStandalone = this.getPagedConfigSetting("standalone", 25);
        PagedFacetFromConfiguration pagedFacet = new PagedFacetFromConfiguration(pagedStandalone, (FacetHolder)facetHolder);
        FacetUtil.addFacet(describedAsFacet);
        FacetUtil.addFacet(titleFacet);
        FacetUtil.addFacet(pagedFacet);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        ArrayList facets = _Lists.newArrayList();
        FacetedMethod facetedMethod = (FacetedMethod)processMethodContext.getFacetHolder();
        String id = facetedMethod.getIdentifier().getMemberName();
        String defaultName = StringExtensions.asNaturalName2(id);
        facets.add(new NamedFacetDefault(defaultName, (FacetHolder)facetedMethod));
        facets.add(new DescribedAsFacetNone(facetedMethod));
        facets.add(new HelpFacetNone(facetedMethod));
        FeatureType featureType = facetedMethod.getFeatureType();
        if (featureType.isProperty()) {
            facets.add(new MaxLengthFacetUnlimited(facetedMethod));
            facets.add(new MultiLineFacetNone(true, (FacetHolder)facetedMethod));
            facets.add(this.newPropParamLayoutFacetIfAny(facetedMethod, "propertyLayout"));
        }
        if (featureType.isAction()) {
            facets.add(new ActionDefaultsFacetNone(facetedMethod));
            facets.add(new ActionChoicesFacetNone(facetedMethod));
        }
        if (featureType.isCollection()) {
            facets.add(new PagedFacetFromConfiguration(this.getPagedConfigSetting("parented", 12), facetedMethod));
        }
        FacetUtil.addFacets(facets);
    }

    @Override
    public void processParams(FacetFactory.ProcessParameterContext processParameterContext) {
        ArrayList<Facet> facets = new ArrayList<Facet>();
        TypedHolder typedHolder = (TypedHolder)processParameterContext.getFacetHolder();
        if (typedHolder.getFeatureType().isActionParameter()) {
            facets.add(new NamedFacetNone(typedHolder));
            facets.add(new DescribedAsFacetNone(typedHolder));
            facets.add(new HelpFacetNone(typedHolder));
            facets.add(new MultiLineFacetNone(false, (FacetHolder)typedHolder));
            facets.add(new MaxLengthFacetUnlimited(typedHolder));
            facets.add(this.newPropParamLayoutFacetIfAny(typedHolder, "parameterLayout"));
        }
        FacetUtil.addFacets(facets);
    }

    private Facet newPropParamLayoutFacetIfAny(FacetHolder facetHolder, String layoutKey) {
        String[] subKeys = new String[]{"labelPosition", "label"};
        String propParamLayout = this.getPropParamLayoutConfigSetting(layoutKey, subKeys);
        if (propParamLayout != null) {
            try {
                LabelPosition labelPosition = LabelPosition.valueOf((String)propParamLayout);
                return new LabelAtFacetFromLayoutConfiguration(labelPosition, facetHolder);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    private int getPagedConfigSetting(String subkey, int defaultValue) {
        return this.getConfiguration().getInteger("isis.viewers.paged." + subkey, defaultValue);
    }

    private String getPropParamLayoutConfigSetting(String layout, String ... subkeys) {
        for (String subkey : subkeys) {
            String layoutKey = "isis.viewers." + layout + "." + subkey;
            String value = this.getConfiguration().getString(layoutKey);
            if (value == null) continue;
            return value;
        }
        return null;
    }
}

