/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.collparam.semantics;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;

public enum CollectionSemantics {
    ARRAY(true),
    COLLECTION_INTERFACE(true),
    LIST_IMPLEMENTATION,
    LIST_INTERFACE(true),
    SORTED_SET_IMPLEMENTATION,
    SORTED_SET_INTERFACE(true),
    SET_IMPLEMENTATION,
    SET_INTERFACE(true),
    OTHER_IMPLEMENTATION;

    final boolean isSupportedInterfaceForActionParameters;

    private CollectionSemantics() {
        this(false);
    }

    private CollectionSemantics(boolean isSupportedInterfaceForActionParameters) {
        this.isSupportedInterfaceForActionParameters = isSupportedInterfaceForActionParameters;
    }

    public static CollectionSemantics of(Class<?> accessorReturnType) {
        if (!Collection.class.isAssignableFrom(accessorReturnType)) {
            return ARRAY;
        }
        if (Collection.class.equals(accessorReturnType)) {
            return COLLECTION_INTERFACE;
        }
        if (List.class.isAssignableFrom(accessorReturnType)) {
            return List.class.equals(accessorReturnType) ? LIST_INTERFACE : LIST_IMPLEMENTATION;
        }
        if (SortedSet.class.isAssignableFrom(accessorReturnType)) {
            return SortedSet.class.equals(accessorReturnType) ? SORTED_SET_INTERFACE : SORTED_SET_IMPLEMENTATION;
        }
        if (Set.class.isAssignableFrom(accessorReturnType)) {
            return Set.class.equals(accessorReturnType) ? SET_INTERFACE : SET_IMPLEMENTATION;
        }
        return OTHER_IMPLEMENTATION;
    }

    public boolean isArray() {
        return this == ARRAY;
    }

    public boolean isList() {
        return this == LIST_IMPLEMENTATION || this == LIST_INTERFACE;
    }

    public boolean isSortedSet() {
        return this == SORTED_SET_IMPLEMENTATION || this == SORTED_SET_INTERFACE;
    }

    public boolean isUnorderedSet() {
        return this == SET_IMPLEMENTATION || this == SET_INTERFACE;
    }

    public boolean isAnySet() {
        return this.isSortedSet() || this.isUnorderedSet();
    }

    public boolean isOther() {
        return this == OTHER_IMPLEMENTATION;
    }

    public boolean isListOrArray() {
        return this.isList() || this.isArray();
    }

    public boolean isSupportedInterfaceForActionParameters() {
        return this.isSupportedInterfaceForActionParameters;
    }
}

