/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.collections.modify;

import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facets.actcoll.typeof.TypeOfFacet;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;

public interface CollectionFacet
extends Facet {
    public int size(ManagedObject var1);

    public <T extends ManagedObject> Stream<T> stream(T var1);

    default public <T extends ManagedObject> T firstElement(T collectionAdapter) {
        return (T)((ManagedObject)this.stream(collectionAdapter).findFirst().orElse(null));
    }

    public <T extends ManagedObject> Object populatePojo(Supplier<Object> var1, ObjectSpecification var2, Stream<T> var3, int var4);

    public TypeOfFacet getTypeOfFacet();

    public static class Utils {
        public static CollectionFacet getCollectionFacetFromSpec(ManagedObject objectRepresentingCollection) {
            ObjectSpecification collectionSpec = objectRepresentingCollection.getSpecification();
            return collectionSpec.getFacet(CollectionFacet.class);
        }

        public static int size(ManagedObject collection) {
            CollectionFacet facet = Utils.getCollectionFacetFromSpec(collection);
            return facet.size(collection);
        }

        public static <T extends ManagedObject> Stream<T> streamAdapters(T collectionAdapter) {
            CollectionFacet facet = Utils.getCollectionFacetFromSpec(collectionAdapter);
            return Utils.downCast(facet.stream(collectionAdapter));
        }

        public static <T extends ManagedObject> List<T> toAdapterList(T collectionAdapter) {
            return Utils.streamAdapters(collectionAdapter).collect(Collectors.toList());
        }

        private static <T extends ManagedObject> Stream<T> downCast(Stream<ManagedObject> stream) {
            Function<ManagedObject, ManagedObject> uncheckedCast = _Casts::uncheckedCast;
            return stream.map(uncheckedCast);
        }
    }
}

