/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.collections.javautilcollection;

import java.util.Collection;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.core.metamodel.adapter.ObjectAdapterProvider;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.collections.CollectionFacetAbstract;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;

public class JavaCollectionFacet
extends CollectionFacetAbstract {
    private final ObjectAdapterProvider adapterProvider;

    public JavaCollectionFacet(FacetHolder holder, ObjectAdapterProvider adapterProvider) {
        super(holder);
        this.adapterProvider = adapterProvider;
    }

    @Override
    public <T extends ManagedObject> Object populatePojo(Supplier<Object> emptyCollectionPojoFactory, ObjectSpecification collectionSpec, Stream<T> initData, int elementCount) {
        Collection pojoCollection = (Collection)_Casts.uncheckedCast((Object)emptyCollectionPojoFactory.get());
        pojoCollection.clear();
        initData.forEach(pojoCollection::add);
        return pojoCollection;
    }

    @Override
    public int size(ManagedObject collection) {
        return this.pojoCollection(collection).size();
    }

    @Override
    public <T extends ManagedObject> Stream<T> stream(T collectionAdapter) {
        return this.pojoCollection(collectionAdapter).stream().map(this.adapterProvider::adapterFor).map(x -> x);
    }

    private Collection<? super Object> pojoCollection(ManagedObject collectionAdapter) {
        return (Collection)collectionAdapter.getPojo();
    }
}

