/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.collections.collection.disabled;

import java.util.List;
import org.apache.isis.applib.annotation.Collection;
import org.apache.isis.applib.annotation.Editing;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.members.disabled.DisabledFacet;
import org.apache.isis.core.metamodel.facets.members.disabled.DisabledFacetAbstractImpl;

public class DisabledFacetForCollectionAnnotation
extends DisabledFacetAbstractImpl {
    public static DisabledFacet create(List<Collection> collections, FacetHolder holder) {
        return collections.stream().filter(collection -> collection.editing() != Editing.NOT_SPECIFIED).findFirst().map(collection -> {
            Editing editing = collection.editing();
            String disabledReason = collection.editingDisabledReason();
            switch (editing) {
                case AS_CONFIGURED: {
                    return null;
                }
                case DISABLED: {
                    return new DisabledFacetForCollectionAnnotation(disabledReason, holder);
                }
                case ENABLED: {
                    return null;
                }
            }
            throw new IllegalStateException("editing '" + editing + "' not recognised");
        }).orElse(null);
    }

    private DisabledFacetForCollectionAnnotation(String reason, FacetHolder holder) {
        super(Where.EVERYWHERE, reason, holder);
    }
}

