/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.collections.collection;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.List;
import org.apache.isis.applib.annotation.Collection;
import org.apache.isis.applib.events.domain.CollectionDomainEvent;
import org.apache.isis.commons.internal.collections._Collections;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.Annotations;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.core.metamodel.facets.actcoll.typeof.TypeOfFacet;
import org.apache.isis.core.metamodel.facets.actcoll.typeof.TypeOfFacetInferredFromArray;
import org.apache.isis.core.metamodel.facets.actcoll.typeof.TypeOfFacetInferredFromGenerics;
import org.apache.isis.core.metamodel.facets.all.hide.HiddenFacet;
import org.apache.isis.core.metamodel.facets.collections.collection.disabled.DisabledFacetForCollectionAnnotation;
import org.apache.isis.core.metamodel.facets.collections.collection.hidden.HiddenFacetForCollectionAnnotation;
import org.apache.isis.core.metamodel.facets.collections.collection.modify.CollectionAddToFacetForDomainEventFromAbstract;
import org.apache.isis.core.metamodel.facets.collections.collection.modify.CollectionAddToFacetForDomainEventFromCollectionAnnotation;
import org.apache.isis.core.metamodel.facets.collections.collection.modify.CollectionAddToFacetForDomainEventFromDefault;
import org.apache.isis.core.metamodel.facets.collections.collection.modify.CollectionDomainEventFacetAbstract;
import org.apache.isis.core.metamodel.facets.collections.collection.modify.CollectionDomainEventFacetDefault;
import org.apache.isis.core.metamodel.facets.collections.collection.modify.CollectionDomainEventFacetForCollectionAnnotation;
import org.apache.isis.core.metamodel.facets.collections.collection.modify.CollectionRemoveFromFacetForDomainEventFromAbstract;
import org.apache.isis.core.metamodel.facets.collections.collection.modify.CollectionRemoveFromFacetForDomainEventFromCollectionAnnotation;
import org.apache.isis.core.metamodel.facets.collections.collection.modify.CollectionRemoveFromFacetForDomainEventFromDefault;
import org.apache.isis.core.metamodel.facets.collections.collection.notpersisted.NotPersistedFacetForCollectionAnnotation;
import org.apache.isis.core.metamodel.facets.collections.collection.typeof.TypeOfFacetOnCollectionFromCollectionAnnotation;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionAddToFacet;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionRemoveFromFacet;
import org.apache.isis.core.metamodel.facets.members.disabled.DisabledFacet;
import org.apache.isis.core.metamodel.facets.object.domainobject.domainevents.CollectionDomainEventDefaultFacetForDomainObjectAnnotation;
import org.apache.isis.core.metamodel.facets.propcoll.accessor.PropertyOrCollectionAccessorFacet;
import org.apache.isis.core.metamodel.facets.propcoll.notpersisted.NotPersistedFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.util.EventUtil;

public class CollectionAnnotationFacetFactory
extends FacetFactoryAbstract {
    public CollectionAnnotationFacetFactory() {
        super(FeatureType.COLLECTIONS_AND_ACTIONS);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        this.processModify(processMethodContext);
        this.processHidden(processMethodContext);
        this.processEditing(processMethodContext);
        this.processNotPersisted(processMethodContext);
        this.processTypeOf(processMethodContext);
    }

    void processModify(FacetFactory.ProcessMethodContext processMethodContext) {
        CollectionRemoveFromFacet collectionRemoveFromFacet;
        CollectionAddToFacet collectionAddToFacet;
        Method method = processMethodContext.getMethod();
        Class<?> cls = processMethodContext.getCls();
        ObjectSpecification typeSpec = this.getSpecificationLoader().loadSpecification(cls);
        Facet holder = processMethodContext.getFacetHolder();
        PropertyOrCollectionAccessorFacet getterFacet = holder.getFacet(PropertyOrCollectionAccessorFacet.class);
        if (getterFacet == null) {
            return;
        }
        List<Collection> collections = Annotations.getAnnotations(method, Collection.class);
        CollectionDomainEventFacetAbstract collectionDomainEventFacet = collections.stream().map(Collection::domainEvent).filter(domainEvent -> domainEvent != CollectionDomainEvent.Default.class).findFirst().map(domainEvent -> new CollectionDomainEventFacetForCollectionAnnotation(CollectionAnnotationFacetFactory.defaultFromDomainObjectIfRequired(typeSpec, domainEvent), this.servicesInjector, this.getSpecificationLoader(), (FacetHolder)((Object)holder))).orElse(new CollectionDomainEventFacetDefault(CollectionAnnotationFacetFactory.defaultFromDomainObjectIfRequired(typeSpec, CollectionDomainEvent.Default.class), this.servicesInjector, this.getSpecificationLoader(), (FacetHolder)((Object)holder)));
        if (!CollectionDomainEvent.Noop.class.isAssignableFrom(collectionDomainEventFacet.getEventType())) {
            FacetUtil.addFacet(collectionDomainEventFacet);
        }
        if (EventUtil.eventTypeIsPostable(collectionDomainEventFacet.getEventType(), CollectionDomainEvent.Noop.class, CollectionDomainEvent.Default.class, "isis.reflector.facet.collectionAnnotation.domainEvent.postForDefault", this.getConfiguration())) {
            FacetUtil.addFacet(collectionDomainEventFacet);
        }
        if ((collectionAddToFacet = holder.getFacet(CollectionAddToFacet.class)) != null) {
            CollectionAddToFacetForDomainEventFromAbstract replacementFacet = collectionDomainEventFacet instanceof CollectionDomainEventFacetForCollectionAnnotation ? new CollectionAddToFacetForDomainEventFromCollectionAnnotation((Class<? extends CollectionDomainEvent<?, ?>>)collectionDomainEventFacet.getEventType(), getterFacet, collectionAddToFacet, collectionDomainEventFacet, (FacetHolder)((Object)holder), this.servicesInjector) : new CollectionAddToFacetForDomainEventFromDefault((Class<? extends CollectionDomainEvent<?, ?>>)collectionDomainEventFacet.getEventType(), getterFacet, collectionAddToFacet, collectionDomainEventFacet, (FacetHolder)((Object)holder), this.servicesInjector);
            FacetUtil.addFacet(replacementFacet);
        }
        if ((collectionRemoveFromFacet = holder.getFacet(CollectionRemoveFromFacet.class)) != null) {
            CollectionRemoveFromFacetForDomainEventFromAbstract replacementFacet = collectionDomainEventFacet instanceof CollectionDomainEventFacetForCollectionAnnotation ? new CollectionRemoveFromFacetForDomainEventFromCollectionAnnotation(collectionDomainEventFacet.getEventType(), getterFacet, collectionRemoveFromFacet, collectionDomainEventFacet, this.servicesInjector, (FacetHolder)((Object)holder)) : new CollectionRemoveFromFacetForDomainEventFromDefault(collectionDomainEventFacet.getEventType(), getterFacet, collectionRemoveFromFacet, collectionDomainEventFacet, this.servicesInjector, (FacetHolder)((Object)holder));
            FacetUtil.addFacet(replacementFacet);
        }
    }

    public static Class<? extends CollectionDomainEvent<?, ?>> defaultFromDomainObjectIfRequired(ObjectSpecification typeSpec, Class<? extends CollectionDomainEvent<?, ?>> collectionDomainEventType) {
        CollectionDomainEventDefaultFacetForDomainObjectAnnotation typeFromDomainObject;
        if (collectionDomainEventType == CollectionDomainEvent.Default.class && (typeFromDomainObject = typeSpec.getFacet(CollectionDomainEventDefaultFacetForDomainObjectAnnotation.class)) != null) {
            return typeFromDomainObject.getEventType();
        }
        return collectionDomainEventType;
    }

    void processHidden(FacetFactory.ProcessMethodContext processMethodContext) {
        Method method = processMethodContext.getMethod();
        Object holder = processMethodContext.getFacetHolder();
        List<Collection> collections = Annotations.getAnnotations(method, Collection.class);
        HiddenFacet facet = HiddenFacetForCollectionAnnotation.create(collections, holder);
        FacetUtil.addFacet(facet);
    }

    void processEditing(FacetFactory.ProcessMethodContext processMethodContext) {
        Method method = processMethodContext.getMethod();
        Object holder = processMethodContext.getFacetHolder();
        List<Collection> collections = Annotations.getAnnotations(method, Collection.class);
        DisabledFacet facet = DisabledFacetForCollectionAnnotation.create(collections, holder);
        FacetUtil.addFacet(facet);
    }

    void processNotPersisted(FacetFactory.ProcessMethodContext processMethodContext) {
        Method method = processMethodContext.getMethod();
        Object holder = processMethodContext.getFacetHolder();
        List<Collection> collections = Annotations.getAnnotations(method, Collection.class);
        NotPersistedFacet facet = NotPersistedFacetForCollectionAnnotation.create(collections, holder);
        FacetUtil.addFacet(facet);
    }

    void processTypeOf(FacetFactory.ProcessMethodContext processMethodContext) {
        Class<?> returnType;
        FacetedMethod facetHolder = (FacetedMethod)processMethodContext.getFacetHolder();
        Method method = processMethodContext.getMethod();
        Class<?> methodReturnType = method.getReturnType();
        if (!_Collections.isCollectionOrArrayType(methodReturnType)) {
            return;
        }
        List<Collection> collections = Annotations.getAnnotations(method, Collection.class);
        TypeOfFacet facet = TypeOfFacetOnCollectionFromCollectionAnnotation.create(collections, facetHolder, this.getSpecificationLoader());
        if (facet == null && (returnType = method.getReturnType()).isArray()) {
            Class<?> componentType = returnType.getComponentType();
            facet = new TypeOfFacetInferredFromArray(componentType, (FacetHolder)facetHolder, this.getSpecificationLoader());
        }
        if (facet == null) {
            facet = this.inferFromGenericReturnType(processMethodContext);
        }
        FacetUtil.addFacet(facet);
    }

    private TypeOfFacet inferFromGenericReturnType(FacetFactory.ProcessMethodContext processMethodContext) {
        FacetedMethod facetHolder = (FacetedMethod)processMethodContext.getFacetHolder();
        Method method = processMethodContext.getMethod();
        Type type = method.getGenericReturnType();
        if (!(type instanceof ParameterizedType)) {
            return null;
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        if (actualTypeArguments.length == 0) {
            return null;
        }
        Type actualTypeArgument = actualTypeArguments[0];
        if (actualTypeArgument instanceof Class) {
            Class actualType = (Class)actualTypeArgument;
            return new TypeOfFacetInferredFromGenerics(actualType, (FacetHolder)facetHolder, this.getSpecificationLoader());
        }
        if (actualTypeArgument instanceof TypeVariable) {
            return null;
        }
        return null;
    }
}

