/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.collections.clear;

import java.lang.reflect.Method;
import org.apache.isis.core.commons.lang.StringExtensions;
import org.apache.isis.core.metamodel.adapter.ObjectAdapterProvider;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.MethodFinderUtils;
import org.apache.isis.core.metamodel.facets.MethodPrefixBasedFacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.collections.clear.CollectionClearFacetViaAccessor;
import org.apache.isis.core.metamodel.facets.collections.clear.CollectionClearFacetViaClearMethod;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionClearFacet;
import org.apache.isis.core.metamodel.methodutils.MethodScope;
import org.apache.isis.core.metamodel.services.ServicesInjector;

public class CollectionClearFacetFactory
extends MethodPrefixBasedFacetFactoryAbstract {
    private static final String[] PREFIXES = new String[]{"clear"};
    ObjectAdapterProvider adapterProvider;

    public CollectionClearFacetFactory() {
        super(FeatureType.COLLECTIONS_ONLY, MethodPrefixBasedFacetFactoryAbstract.OrphanValidation.VALIDATE, PREFIXES);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        this.attachCollectionClearFacets(processMethodContext);
    }

    private void attachCollectionClearFacets(FacetFactory.ProcessMethodContext processMethodContext) {
        Method getMethod = processMethodContext.getMethod();
        String capitalizedName = StringExtensions.asJavaBaseName(getMethod.getName());
        Class<?> cls = processMethodContext.getCls();
        Method method = MethodFinderUtils.findMethod(cls, MethodScope.OBJECT, "clear" + capitalizedName, Void.TYPE, null);
        processMethodContext.removeMethod(method);
        Object collection = processMethodContext.getFacetHolder();
        FacetUtil.addFacet(this.createCollectionClearFacet(method, getMethod, (FacetHolder)collection));
    }

    private CollectionClearFacet createCollectionClearFacet(Method clearMethodIfAny, Method accessorMethod, FacetHolder collection) {
        if (clearMethodIfAny != null) {
            return new CollectionClearFacetViaClearMethod(clearMethodIfAny, collection);
        }
        return new CollectionClearFacetViaAccessor(accessorMethod, collection, this.adapterProvider);
    }

    @Override
    public void setServicesInjector(ServicesInjector servicesInjector) {
        super.setServicesInjector(servicesInjector);
        this.adapterProvider = servicesInjector.getPersistenceSessionServiceInternal();
    }
}

