/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.collections.accessor;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.config.internal._Config;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ObjectAdapterProvider;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.CollectionUtils;
import org.apache.isis.core.metamodel.facets.ImperativeFacet;
import org.apache.isis.core.metamodel.facets.propcoll.accessor.PropertyOrCollectionAccessorFacetAbstract;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.security.authentication.AuthenticationSessionProvider;

public class CollectionAccessorFacetViaAccessor
extends PropertyOrCollectionAccessorFacetAbstract
implements ImperativeFacet {
    private final Method method;

    public CollectionAccessorFacetViaAccessor(ObjectSpecification typeSpec, Method method, FacetHolder holder, SpecificationLoader specificationLoader, AuthenticationSessionProvider authenticationSessionProvider, ObjectAdapterProvider adapterManager) {
        super(typeSpec, holder, specificationLoader, authenticationSessionProvider, adapterManager);
        this.method = method;
    }

    @Override
    public List<Method> getMethods() {
        return Collections.singletonList(this.method);
    }

    @Override
    public ImperativeFacet.Intent getIntent(Method method) {
        return ImperativeFacet.Intent.ACCESSOR;
    }

    @Override
    public Object getProperty(ManagedObject owningAdapter, InteractionInitiatedBy interactionInitiatedBy) {
        List<ObjectAdapter> visibleAdapters;
        Object visibleObjects;
        Object collectionOrArray = ObjectAdapter.InvokeUtils.invoke(this.method, owningAdapter);
        if (collectionOrArray == null) {
            return null;
        }
        ObjectAdapter collectionAdapter = this.getObjectAdapterProvider().adapterFor(collectionOrArray);
        boolean filterForVisibility = _Config.getConfiguration().getBoolean("isis.reflector.facet.filterVisibility", true);
        if (filterForVisibility && (visibleObjects = CollectionUtils.copyOf(_Lists.map(visibleAdapters = ObjectAdapter.Util.visibleAdapters(collectionAdapter, interactionInitiatedBy), ObjectAdapter.Util::unwrapPojo), this.method.getReturnType())) != null) {
            return visibleObjects;
        }
        return collectionOrArray;
    }

    @Override
    protected String toStringValues() {
        return "method=" + this.method;
    }

    @Override
    public void appendAttributesTo(Map<String, Object> attributeMap) {
        super.appendAttributesTo(attributeMap);
        ImperativeFacet.Util.appendAttributesTo(this, attributeMap);
    }
}

