/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.actions.command;

import java.util.Map;
import org.apache.isis.applib.annotation.CommandExecuteIn;
import org.apache.isis.applib.annotation.CommandPersistence;
import org.apache.isis.applib.services.command.CommandDtoProcessor;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.MarkerFacetAbstract;
import org.apache.isis.core.metamodel.facets.actions.command.CommandFacet;
import org.apache.isis.core.metamodel.services.ServicesInjector;

public abstract class CommandFacetAbstract
extends MarkerFacetAbstract
implements CommandFacet {
    private final CommandPersistence persistence;
    private final CommandExecuteIn executeIn;
    private final Enablement enablement;
    private final CommandDtoProcessor processor;

    public static Class<? extends Facet> type() {
        return CommandFacet.class;
    }

    public CommandFacetAbstract(CommandPersistence persistence, CommandExecuteIn executeIn, Enablement enablement, CommandDtoProcessor processor, FacetHolder holder, ServicesInjector servicesInjector) {
        super(CommandFacetAbstract.type(), holder);
        CommandFacetAbstract.inject(processor, servicesInjector);
        this.persistence = persistence;
        this.executeIn = executeIn;
        this.enablement = enablement;
        this.processor = processor;
    }

    private static void inject(CommandDtoProcessor processor, ServicesInjector servicesInjector) {
        if (processor == null || servicesInjector == null) {
            return;
        }
        servicesInjector.injectServicesInto(processor);
    }

    @Override
    public CommandPersistence persistence() {
        return this.persistence;
    }

    @Override
    public CommandExecuteIn executeIn() {
        return this.executeIn;
    }

    @Override
    public boolean isDisabled() {
        return this.enablement == Enablement.DISABLED;
    }

    @Override
    public CommandDtoProcessor getProcessor() {
        return this.processor;
    }

    protected static CommandDtoProcessor newProcessorElseNull(Class<?> cls) {
        if (cls == null) {
            return null;
        }
        if (cls == CommandDtoProcessor.class) {
            return null;
        }
        if (!CommandDtoProcessor.class.isAssignableFrom(cls)) {
            return null;
        }
        try {
            return (CommandDtoProcessor)cls.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            return null;
        }
    }

    @Override
    public void appendAttributesTo(Map<String, Object> attributeMap) {
        super.appendAttributesTo(attributeMap);
        attributeMap.put("executeIn", this.executeIn);
        attributeMap.put("persistence", this.persistence);
        attributeMap.put("disabled", this.isDisabled());
        attributeMap.put("dtoProcessor", this.processor);
    }

    public static enum Enablement {
        DISABLED,
        ENABLED;


        public static Enablement isDisabled(boolean disabled) {
            return disabled ? DISABLED : ENABLED;
        }
    }
}

