/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.actions.action.publishing;

import java.util.List;
import org.apache.isis.applib.annotation.Action;
import org.apache.isis.applib.annotation.Publishing;
import org.apache.isis.applib.annotation.SemanticsOf;
import org.apache.isis.config.IsisConfiguration;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.actions.action.publishing.PublishActionsConfiguration;
import org.apache.isis.core.metamodel.facets.actions.action.publishing.PublishedActionFacetForActionAnnotationAsConfigured;
import org.apache.isis.core.metamodel.facets.actions.action.publishing.PublishedActionFacetFromConfiguration;
import org.apache.isis.core.metamodel.facets.actions.publish.PublishedActionFacet;
import org.apache.isis.core.metamodel.facets.actions.publish.PublishedActionFacetAbstract;
import org.apache.isis.core.metamodel.facets.actions.semantics.ActionSemanticsFacet;

public class PublishedActionFacetForActionAnnotation
extends PublishedActionFacetAbstract {
    public static PublishedActionFacet create(List<Action> actions, IsisConfiguration configuration, FacetHolder holder) {
        PublishActionsConfiguration setting = PublishActionsConfiguration.parse(configuration);
        return actions.stream().map(Action::publishing).filter(publishing -> publishing != Publishing.NOT_SPECIFIED).findFirst().map(publishing -> {
            switch (publishing) {
                case AS_CONFIGURED: {
                    switch (setting) {
                        case NONE: {
                            return null;
                        }
                        case IGNORE_SAFE: {
                            if (!PublishedActionFacetForActionAnnotation.hasSafeSemantics(holder)) break;
                            return null;
                        }
                    }
                    return new PublishedActionFacetForActionAnnotationAsConfigured(holder);
                }
                case DISABLED: {
                    return null;
                }
                case ENABLED: {
                    return new PublishedActionFacetForActionAnnotation(holder);
                }
            }
            throw new IllegalStateException("publishing '" + publishing + "' not recognised");
        }).orElseGet(() -> {
            switch (setting) {
                case NONE: {
                    return null;
                }
                case IGNORE_SAFE: {
                    if (!PublishedActionFacetForActionAnnotation.hasSafeSemantics(holder)) break;
                    return null;
                }
            }
            return new PublishedActionFacetFromConfiguration(holder);
        });
    }

    private static boolean hasSafeSemantics(FacetHolder holder) {
        ActionSemanticsFacet actionSemanticsFacet = holder.getFacet(ActionSemanticsFacet.class);
        if (actionSemanticsFacet == null) {
            throw new IllegalStateException("Require ActionSemanticsFacet in order to process");
        }
        return ((SemanticsOf)actionSemanticsFacet.value()).isSafeInNature();
    }

    PublishedActionFacetForActionAnnotation(FacetHolder holder) {
        super(holder);
    }
}

