/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.actions.action.invocation;

import java.util.List;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.collections._Arrays;
import org.apache.isis.core.commons.lang.StringExtensions;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ObjectAdapterProvider;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectActionParameter;
import org.apache.isis.core.metamodel.spec.feature.ObjectMember;

public class CommandUtil {
    private CommandUtil() {
    }

    public static String targetMemberNameFor(ObjectMember objectMember) {
        return objectMember.getName();
    }

    public static String targetClassNameFor(ObjectAdapter targetAdapter) {
        return StringExtensions.asNaturalName2(targetAdapter.getSpecification().getSingularName());
    }

    public static String memberIdentifierFor(ObjectMember objectMember) {
        return objectMember.getIdentifier().toClassAndNameIdentityString();
    }

    public static String argDescriptionFor(ObjectAdapter valueAdapter) {
        StringBuilder buf = new StringBuilder();
        if (valueAdapter != null) {
            CommandUtil.appendArg(buf, "new value", valueAdapter);
        } else {
            buf.append("cleared");
        }
        return buf.toString();
    }

    public static String argDescriptionFor(ObjectAction owningAction, ObjectAdapter[] arguments) {
        StringBuilder argsBuf = new StringBuilder();
        List<ObjectActionParameter> parameters = owningAction.getParameters();
        if (parameters.size() == arguments.length) {
            int i = 0;
            for (ObjectActionParameter param : parameters) {
                CommandUtil.appendParamArg(argsBuf, param, arguments[i++]);
            }
        }
        return argsBuf.toString();
    }

    public static Bookmark bookmarkFor(ObjectAdapter adapter) {
        Oid oid = adapter.getOid();
        if (!(oid instanceof RootOid)) {
            return null;
        }
        RootOid rootOid = (RootOid)oid;
        return rootOid.asBookmark();
    }

    static void appendParamArg(StringBuilder buf, ObjectActionParameter param, ObjectAdapter objectAdapter) {
        String name = param.getName();
        CommandUtil.appendArg(buf, name, objectAdapter);
    }

    private static void appendArg(StringBuilder buf, String name, ObjectAdapter objectAdapter) {
        String titleOf = objectAdapter != null ? objectAdapter.titleString(null) : "null";
        buf.append(name).append(": ").append(titleOf).append("\n");
    }

    public static ObjectAdapter[] adaptersFor(Object[] args, ObjectAdapterProvider adapterProvider) {
        return (ObjectAdapter[])_NullSafe.stream((Object[])args).map(adapterProvider::adapterFor).collect(_Arrays.toArray(ObjectAdapter.class, (int)_NullSafe.size((Object[])args)));
    }
}

