/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.actions.action;

import org.apache.isis.config.internal._Config;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MetaModelValidatorRefiner;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.collparam.semantics.CollectionSemantics;
import org.apache.isis.core.metamodel.facets.collparam.semantics.CollectionSemanticsFacet;
import org.apache.isis.core.metamodel.facets.object.autocomplete.AutoCompleteFacet;
import org.apache.isis.core.metamodel.facets.param.autocomplete.ActionParameterAutoCompleteFacet;
import org.apache.isis.core.metamodel.facets.param.choices.ActionParameterChoicesFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectActionParameter;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectActionContributee;
import org.apache.isis.core.metamodel.specloader.specimpl.ObjectActionMixedIn;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorComposite;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorVisiting;
import org.apache.isis.core.metamodel.specloader.validator.ValidationFailures;

public class ActionChoicesForCollectionParameterFacetFactory
extends FacetFactoryAbstract
implements MetaModelValidatorRefiner {
    public static final String ISIS_REFLECTOR_VALIDATOR_ACTION_COLLECTION_PARAMETER_CHOICES_KEY = "isis.reflector.validator.actionCollectionParameterChoices";
    public static final boolean ISIS_REFLECTOR_VALIDATOR_ACTION_COLLECTION_PARAMETER_CHOICES_DEFAULT = true;

    public ActionChoicesForCollectionParameterFacetFactory() {
        super(FeatureType.ACTIONS_ONLY);
    }

    @Override
    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
    }

    @Override
    public void refineMetaModelValidator(MetaModelValidatorComposite metaModelValidator) {
        boolean doCheck = _Config.getConfiguration().getBoolean(ISIS_REFLECTOR_VALIDATOR_ACTION_COLLECTION_PARAMETER_CHOICES_KEY, true);
        if (!doCheck) {
            return;
        }
        MetaModelValidatorVisiting validator = new MetaModelValidatorVisiting(new MetaModelValidatorVisiting.Visitor(){

            @Override
            public boolean visit(ObjectSpecification objectSpec, ValidationFailures validationFailures) {
                this.validate(objectSpec, validationFailures);
                return true;
            }

            private void validate(ObjectSpecification objectSpec, ValidationFailures validationFailures) {
                objectSpec.streamObjectActions(Contributed.INCLUDED).forEach(objectAction -> {
                    if (objectAction instanceof ObjectActionMixedIn || objectAction instanceof ObjectActionContributee) {
                        return;
                    }
                    int paramNum = 0;
                    for (ObjectActionParameter parameter : objectAction.getParameters()) {
                        if (parameter.getFeatureType() == FeatureType.ACTION_PARAMETER_COLLECTION) {
                            this.validate(objectSpec, (ObjectAction)objectAction, parameter, paramNum, validationFailures);
                        }
                        ++paramNum;
                    }
                });
            }

            private void validate(ObjectSpecification objectSpec, ObjectAction objectAction, ObjectActionParameter parameter, int paramNum, ValidationFailures validationFailures) {
                CollectionSemanticsFacet collectionSemantics = parameter.getFacet(CollectionSemanticsFacet.class);
                if (collectionSemantics != null && !((CollectionSemantics)((Object)collectionSemantics.value())).isSupportedInterfaceForActionParameters()) {
                    validationFailures.add("Collection action parameter found that is not exactly one of the following supported types: List, Set, SortedSet, Collection or Array.  Class: %s action: %s parameter %d", objectSpec.getFullIdentifier(), objectAction.getName(), paramNum);
                    return;
                }
                ActionParameterChoicesFacet choicesFacet = parameter.getFacet(ActionParameterChoicesFacet.class);
                ActionParameterAutoCompleteFacet autoCompleteFacet = parameter.getFacet(ActionParameterAutoCompleteFacet.class);
                if (choicesFacet != null || autoCompleteFacet != null) {
                    return;
                }
                ObjectSpecification parameterType = parameter.getSpecification();
                if (parameterType.containsDoOpFacet(AutoCompleteFacet.class)) {
                    return;
                }
                validationFailures.add("Collection action parameter found without supporting choices or autoComplete facet.  Class: %s action: %s parameter %d", objectSpec.getFullIdentifier(), objectAction.getName(), paramNum);
            }
        });
        metaModelValidator.add(validator);
    }
}

