/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets.actcoll.typeof;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.commons.internal.collections._Arrays;
import org.apache.isis.commons.internal.collections._Collections;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.SingleClassValueFacet;
import org.apache.isis.core.metamodel.facets.actcoll.typeof.TypeOfFacetInferredFromArray;
import org.apache.isis.core.metamodel.facets.actcoll.typeof.TypeOfFacetInferredFromGenerics;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;

public interface TypeOfFacet
extends SingleClassValueFacet {

    public static class Util {
        private Util() {
        }

        @Programmatic
        public static TypeOfFacet inferFromGenericReturnType(Class<?> cls, Method method, FacetHolder holder, SpecificationLoader specificationLoader) {
            Class<?> methodReturnType = method.getReturnType();
            if (!_Collections.isCollectionType(methodReturnType)) {
                return null;
            }
            Type type = method.getGenericReturnType();
            if (!(type instanceof ParameterizedType)) {
                return null;
            }
            ParameterizedType methodParameterizedType = (ParameterizedType)type;
            Type[] methodActualTypeArguments = methodParameterizedType.getActualTypeArguments();
            if (methodActualTypeArguments.length == 0) {
                return null;
            }
            Type methodActualTypeArgument = methodActualTypeArguments[0];
            if (methodActualTypeArgument instanceof Class) {
                Class actualType = (Class)methodActualTypeArgument;
                return new TypeOfFacetInferredFromGenerics(actualType, holder, specificationLoader);
            }
            if (methodActualTypeArgument instanceof TypeVariable) {
                ParameterizedType parameterizedTypeOfSuperclass;
                TypeVariable methodTypeVariable = (TypeVariable)methodActualTypeArgument;
                Object methodGenericClassDeclaration = methodTypeVariable.getGenericDeclaration();
                Type genericSuperclass = cls.getGenericSuperclass();
                if (genericSuperclass instanceof ParameterizedType && (parameterizedTypeOfSuperclass = (ParameterizedType)genericSuperclass).getRawType() == methodGenericClassDeclaration) {
                    Type actualType;
                    Type[] genericSuperClassActualTypeArguments = parameterizedTypeOfSuperclass.getActualTypeArguments();
                    if (methodActualTypeArguments.length == 1 && (actualType = genericSuperClassActualTypeArguments[0]) instanceof Class) {
                        Class actualCls = (Class)actualType;
                        return new TypeOfFacetInferredFromGenerics(actualCls, holder, specificationLoader);
                    }
                }
            }
            return null;
        }

        @Programmatic
        public static TypeOfFacet inferFromArrayType(FacetHolder holder, Class<?> type, SpecificationLoader specificationLoader) {
            Class elementType = _Arrays.inferComponentTypeIfAny(type);
            return elementType != null ? new TypeOfFacetInferredFromArray(elementType, holder, specificationLoader) : null;
        }

        @Programmatic
        public static TypeOfFacet inferFromGenericParamType(FacetHolder holder, Class<?> parameterType, Type genericParameterType, SpecificationLoader specificationLoader) {
            Class elementType = _Collections.inferElementTypeIfAny(parameterType, (Type)genericParameterType);
            return elementType != null ? new TypeOfFacetInferredFromGenerics(elementType, holder, specificationLoader) : null;
        }
    }
}

