/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets;

import java.util.Map;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetAbstract;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.SingleClassValueFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;

public abstract class SingleClassValueFacetAbstract
extends FacetAbstract
implements SingleClassValueFacet {
    private final Class<?> value;
    private final SpecificationLoader specificationLoader;

    public SingleClassValueFacetAbstract(Class<? extends Facet> facetType, FacetHolder holder, Class<?> value, SpecificationLoader specificationLoader) {
        super(facetType, holder, FacetAbstract.Derivation.NOT_DERIVED);
        this.value = value;
        this.specificationLoader = specificationLoader;
    }

    @Override
    public Class<?> value() {
        return this.value;
    }

    @Override
    public ObjectSpecification valueSpec() {
        Class<?> valueType = this.value();
        return valueType != null ? this.getSpecificationLoader().loadSpecification(valueType) : null;
    }

    private SpecificationLoader getSpecificationLoader() {
        return this.specificationLoader;
    }

    @Override
    public void appendAttributesTo(Map<String, Object> attributeMap) {
        super.appendAttributesTo(attributeMap);
        attributeMap.put("value", this.value());
    }
}

