/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.core.commons.lang.ObjectExtensions;
import org.apache.isis.core.metamodel.facetapi.DecoratingFacet;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.spec.feature.ObjectMember;

public interface ImperativeFacet
extends Facet {
    public static final Predicate<Facet> PREDICATE = Util::isImperativeFacet;

    public List<Method> getMethods();

    public Intent getIntent(Method var1);

    public static class Util {
        private Util() {
        }

        public static ImperativeFacet getImperativeFacet(Facet facet) {
            if (facet instanceof ImperativeFacet) {
                return (ImperativeFacet)facet;
            }
            if (facet.getUnderlyingFacet() instanceof ImperativeFacet) {
                return (ImperativeFacet)facet.getUnderlyingFacet();
            }
            if (facet instanceof DecoratingFacet) {
                DecoratingFacet decoratingFacet = (DecoratingFacet)ObjectExtensions.asT(facet);
                return Util.getImperativeFacet(decoratingFacet.getDecoratedFacet());
            }
            return null;
        }

        public static boolean isImperativeFacet(Facet facet) {
            return Util.getImperativeFacet(facet) != null;
        }

        public static Intent getIntent(ObjectMember member, Method method) {
            ArrayList imperativeFacets = _Lists.newArrayList();
            Stream<Facet> allFacets = member.streamFacets();
            allFacets.forEach(facet -> {
                ImperativeFacet imperativeFacet = Util.getImperativeFacet(facet);
                if (imperativeFacet == null) {
                    return;
                }
                List<Method> methods = imperativeFacet.getMethods();
                if (!methods.contains(method)) {
                    return;
                }
                imperativeFacets.add(imperativeFacet);
            });
            switch (imperativeFacets.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    return ((ImperativeFacet)imperativeFacets.get(0)).getIntent(method);
                }
                default: {
                    Intent intentToReturn = null;
                    for (ImperativeFacet imperativeFacet : imperativeFacets) {
                        Intent intent = imperativeFacet.getIntent(method);
                        if (intentToReturn == null) {
                            intentToReturn = intent;
                            continue;
                        }
                        if (intentToReturn == intent) continue;
                        throw new IllegalArgumentException(member.getIdentifier().toClassAndNameIdentityString() + ": more than one ImperativeFacet for method " + method.getName() + " , with inconsistent intents: " + ((Object)imperativeFacets).toString());
                    }
                    return intentToReturn;
                }
            }
            throw new IllegalArgumentException(member.getIdentifier().toClassAndNameIdentityString() + ": unable to determine intent of " + method.getName());
        }

        public static void appendAttributesTo(ImperativeFacet facet, Map<String, Object> attributeMap) {
            List<Method> methods = facet.getMethods();
            attributeMap.put("methods", methods);
            for (Method method : methods) {
                Intent intent = facet.getIntent(method);
                attributeMap.put("intent." + method.getName(), (Object)intent);
            }
        }
    }

    public static enum Intent {
        CHECK_IF_HIDDEN,
        CHECK_IF_DISABLED,
        CHECK_IF_VALID,
        ACCESSOR,
        EXECUTE,
        MODIFY_PROPERTY,
        MODIFY_PROPERTY_SUPPORTING,
        MODIFY_COLLECTION_ADD,
        MODIFY_COLLECTION_REMOVE,
        CHOICES_OR_AUTOCOMPLETE,
        DEFAULTS,
        INITIALIZATION,
        LIFECYCLE,
        UI_HINT;

    }
}

