/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MethodRemover;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.core.metamodel.facets.FacetedMethodParameter;
import org.apache.isis.core.metamodel.methodutils.MethodScope;

public interface FacetFactory {
    public List<FeatureType> getFeatureTypes();

    public void process(ProcessClassContext var1);

    public void process(ProcessMethodContext var1);

    public void processParams(ProcessParameterContext var1);

    public static class ProcessParameterContext
    extends AbstractProcessWithMethodContext<FacetedMethodParameter> {
        private final int paramNum;

        public ProcessParameterContext(Class<?> cls, Method method, int paramNum, MethodRemover methodRemover, FacetedMethodParameter facetedMethodParameter) {
            super(cls, method, methodRemover, facetedMethodParameter);
            this.paramNum = paramNum;
        }

        public int getParamNum() {
            return this.paramNum;
        }
    }

    public static class ProcessMethodContext
    extends AbstractProcessWithMethodContext<FacetedMethod>
    implements ProcessContextWithMetadataProperties<FacetedMethod> {
        private final FeatureType featureType;

        public ProcessMethodContext(Class<?> cls, FeatureType featureType, Method method, MethodRemover methodRemover, FacetedMethod facetedMethod) {
            super(cls, method, methodRemover, facetedMethod);
            this.featureType = featureType;
        }

        public FeatureType getFeatureType() {
            return this.featureType;
        }
    }

    public static class ProcessClassContext
    extends AbstractProcessWithClsContext<FacetHolder>
    implements MethodRemover,
    ProcessContextWithMetadataProperties<FacetHolder> {
        private final MethodRemover methodRemover;

        public ProcessClassContext(Class<?> cls, MethodRemover methodRemover, FacetHolder facetHolder) {
            super(cls, facetHolder);
            this.methodRemover = methodRemover;
        }

        @Override
        public void removeMethod(Method method) {
            this.methodRemover.removeMethod(method);
        }

        @Override
        public List<Method> removeMethods(MethodScope methodScope, String prefix, Class<?> returnType, boolean canBeVoid, int paramCount) {
            return this.methodRemover.removeMethods(methodScope, prefix, returnType, canBeVoid, paramCount);
        }

        @Override
        public void removeMethod(MethodScope methodScope, String methodName, Class<?> returnType, Class<?>[] parameterTypes) {
            this.methodRemover.removeMethod(methodScope, methodName, returnType, parameterTypes);
        }

        @Override
        public void removeMethods(List<Method> methods) {
            this.methodRemover.removeMethods(methods);
        }
    }

    public static interface ProcessContextWithMetadataProperties<T extends FacetHolder> {
        public T getFacetHolder();
    }

    public static class AbstractProcessWithMethodContext<T extends FacetHolder>
    extends AbstractProcessWithClsContext<T>
    implements MethodRemover {
        private final Method method;
        protected final MethodRemover methodRemover;

        AbstractProcessWithMethodContext(Class<?> cls, Method method, MethodRemover methodRemover, T facetHolder) {
            super(cls, facetHolder);
            this.method = method;
            this.methodRemover = methodRemover;
        }

        @Override
        public Class<?> getCls() {
            return super.getCls();
        }

        public Method getMethod() {
            return this.method;
        }

        @Override
        public List<Method> removeMethods(MethodScope methodScope, String prefix, Class<?> returnType, boolean canBeVoid, int paramCount) {
            return this.methodRemover.removeMethods(methodScope, prefix, returnType, canBeVoid, paramCount);
        }

        @Override
        public void removeMethod(MethodScope methodScope, String methodName, Class<?> returnType, Class<?>[] parameterTypes) {
            this.methodRemover.removeMethod(methodScope, methodName, returnType, parameterTypes);
        }

        @Override
        public void removeMethod(Method method) {
            this.methodRemover.removeMethod(method);
        }

        @Override
        public void removeMethods(List<Method> methods) {
            this.methodRemover.removeMethods(methods);
        }
    }

    public static class AbstractProcessWithClsContext<T extends FacetHolder>
    extends AbstractProcessContext<T> {
        private final Class<?> cls;

        AbstractProcessWithClsContext(Class<?> cls, T facetHolder) {
            super(facetHolder);
            this.cls = cls;
        }

        public Class<?> getCls() {
            return this.cls;
        }
    }

    public static class AbstractProcessContext<T extends FacetHolder> {
        private final T facetHolder;

        public AbstractProcessContext(T facetHolder) {
            this.facetHolder = facetHolder;
        }

        public T getFacetHolder() {
            return this.facetHolder;
        }
    }
}

