/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facets;

import java.util.AbstractList;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.commons.internal.base._With;
import org.apache.isis.commons.internal.collections._Arrays;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.commons.internal.collections._Sets;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ObjectAdapterProvider;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;

public final class CollectionUtils {
    private static final Map<Class<?>, Function<Iterable<Object>, Object>> factoriesByType = _With.hashMap(map -> {
        map.put(CopyOnWriteArrayList.class, _Lists::newCopyOnWriteArrayList);
        map.put(LinkedList.class, _Lists::newLinkedList);
        map.put(ArrayList.class, _Lists::newArrayList);
        map.put(AbstractList.class, _Lists::newArrayList);
        map.put(CopyOnWriteArraySet.class, _Sets::newCopyOnWriteArraySet);
        map.put(LinkedHashSet.class, _Sets::newLinkedHashSet);
        map.put(HashSet.class, _Sets::newHashSet);
        map.put(TreeSet.class, _Sets::newTreeSet);
        map.put(AbstractSet.class, _Sets::newLinkedHashSet);
        map.put(List.class, _Lists::newArrayList);
        map.put(SortedSet.class, _Sets::newTreeSet);
        map.put(Set.class, _Sets::newLinkedHashSet);
        map.put(Collection.class, _Lists::newArrayList);
    });

    private CollectionUtils() {
    }

    public static Object[] getCollectionAsObjectArray(Object option, ObjectSpecification spec, ObjectAdapterProvider adapterProvider) {
        ObjectAdapter collection = adapterProvider.adapterFor(option);
        CollectionFacet facet = CollectionFacet.Utils.getCollectionFacetFromSpec(collection);
        Stream<ObjectAdapter> objectAdapters = CollectionFacet.Utils.streamAdapters(collection);
        return (Object[])objectAdapters.map(nextElement -> nextElement != null ? nextElement.getPojo() : null).collect(_Arrays.toArray(Object.class, (int)facet.size(collection)));
    }

    public static Object copyOf(Iterable<Object> iterable, Class<?> requiredType) {
        if (iterable == null) {
            throw new IllegalArgumentException("Iterable must be provided");
        }
        if (requiredType == null) {
            throw new IllegalArgumentException("RequiredType must be provided");
        }
        Function<Iterable<Object>, Object> factory = factoriesByType.get(requiredType);
        if (factory != null) {
            return factory.apply(iterable);
        }
        if (requiredType.isArray()) {
            Class<?> componentType = requiredType.getComponentType();
            Iterable<Object> rawIterable = iterable;
            return _Arrays.toArray((Collection)((Collection)_Casts.uncheckedCast(rawIterable)), componentType);
        }
        return null;
    }
}

