/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.facetapi;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.MultiTypedFacet;
import org.apache.isis.core.runtime.snapshot.XmlSchema;

public final class FacetUtil {
    private FacetUtil() {
    }

    public static void addOrReplaceFacet(Facet facet) {
        if (facet == null) {
            return;
        }
        FacetHolder facetHolder = facet.getFacetHolder();
        Optional.ofNullable(facetHolder.getFacet(facet.facetType())).filter(each -> facet.getClass() == each.getClass()).ifPresent(existingFacet -> {
            Facet underlyingFacet = existingFacet.getUnderlyingFacet();
            facetHolder.removeFacet((Facet)existingFacet);
            facet.setUnderlyingFacet(underlyingFacet);
        });
        facetHolder.addFacet(facet);
    }

    public static boolean addFacet(Facet facet) {
        if (facet == null) {
            return false;
        }
        facet.getFacetHolder().addFacet(facet);
        return true;
    }

    public static boolean addFacet(MultiTypedFacet facet) {
        if (facet == null) {
            return false;
        }
        facet.getFacetHolder().addFacet(facet);
        return true;
    }

    public static boolean addFacets(List<Facet> facetList) {
        boolean addedFacets = false;
        for (Facet facet : facetList) {
            addedFacets = FacetUtil.addFacet(facet) | addedFacets;
        }
        return addedFacets;
    }

    public static void removeFacet(Map<Class<? extends Facet>, Facet> facetsByClass, Facet facet) {
        FacetUtil.removeFacet(facetsByClass, facet.facetType());
    }

    public static void removeFacet(Map<Class<? extends Facet>, Facet> facetsByClass, Class<? extends Facet> facetType) {
        Facet facet = facetsByClass.get(facetType);
        if (facet == null) {
            return;
        }
        facetsByClass.remove(facetType);
        facet.setFacetHolder(null);
    }

    public static void addFacet(Map<Class<? extends Facet>, Facet> facetsByClass, Facet facet) {
        facetsByClass.put(facet.facetType(), facet);
    }

    public static <T extends Facet> XmlSchema.ExtensionData<T> getFacetsByType(final FacetHolder facetHolder) {
        return new XmlSchema.ExtensionData<T>(){

            @Override
            public int size() {
                return facetHolder.getFacetCount();
            }

            @Override
            public void visit(BiConsumer<Class<T>, T> elementConsumer) {
                facetHolder.streamFacets().forEach(facet -> elementConsumer.accept(facet.facetType(), facet));
            }
        };
    }

    public static void copyFacets(FacetHolder source, FacetHolder target) {
        source.streamFacets().forEach(target::addFacet);
    }
}

