/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.adapter.oid;

import java.io.IOException;
import java.util.Objects;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.commons.internal.base._With;
import org.apache.isis.core.commons.encoding.DataInputExtended;
import org.apache.isis.core.commons.encoding.DataOutputExtended;
import org.apache.isis.core.commons.url.UrlDecoderUtil;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.adapter.oid.Oid_State;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.adapter.version.Version;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.apache.isis.schema.common.v1.OidDto;

final class Oid_Root
implements RootOid {
    private static final long serialVersionUID = 1L;
    private final ObjectSpecId objectSpecId;
    private final String identifier;
    private final Oid_State state;
    private final int hashCode;
    private Version version;

    public static Oid_Root of(ObjectSpecId objectSpecId, String identifier, Oid_State state) {
        return Oid_Root.of(objectSpecId, identifier, state, Version.empty());
    }

    public static Oid_Root of(ObjectSpecId objectSpecId, String identifier, Oid_State state, Version version) {
        return new Oid_Root(objectSpecId, identifier, state, version);
    }

    private Oid_Root(ObjectSpecId objectSpecId, String identifier, Oid_State state, Version version) {
        _With.requires((Object)objectSpecId, (String)"objectSpecId");
        _With.requires((Object)identifier, (String)"identifier");
        _With.requires((Object)((Object)state), (String)"state");
        this.objectSpecId = objectSpecId;
        this.identifier = identifier;
        this.state = state;
        this.version = version;
        this.hashCode = this.calculateHash();
    }

    public Oid_Root(DataInputExtended input) throws IOException {
        String oidStr = input.readUTF();
        Oid_Root oid = Oid.unmarshaller().unmarshal(oidStr, Oid_Root.class);
        this.objectSpecId = oid.objectSpecId;
        this.identifier = oid.identifier;
        this.state = oid.state;
        _With.requires((Object)this.objectSpecId, (String)"objectSpecId");
        _With.requires((Object)this.identifier, (String)"identifier");
        _With.requires((Object)((Object)this.state), (String)"state");
        this.version = oid.version;
        this.hashCode = this.calculateHash();
    }

    public void encode(DataOutputExtended output) throws IOException {
        output.writeUTF(this.enString());
    }

    public static Oid_Root deStringEncoded(String urlEncodedOidStr) {
        String oidStr = UrlDecoderUtil.urlDecode(urlEncodedOidStr);
        return Oid_Root.deString(oidStr);
    }

    public static Oid_Root deString(String oidStr) {
        return Oid.unmarshaller().unmarshal(oidStr, Oid_Root.class);
    }

    @Override
    public String enString() {
        return Oid.marshaller().marshal(this);
    }

    @Override
    public String enStringNoVersion() {
        return Oid.marshaller().marshalNoVersion(this);
    }

    @Override
    public ObjectSpecId getObjectSpecId() {
        return this.objectSpecId;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public boolean isTransient() {
        return this.state.isTransient();
    }

    @Override
    public boolean isViewModel() {
        return this.state.isViewModel();
    }

    @Override
    public boolean isPersistent() {
        return this.state.isPersistent();
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(Version version) {
        this.version = version;
    }

    @Override
    public Bookmark asBookmark() {
        return this.state.bookmarkOf(this);
    }

    @Override
    public OidDto asOidDto() {
        return this.state.toOidDto(this);
    }

    private int calculateHash() {
        return Objects.hash(new Object[]{this.objectSpecId, this.identifier, this.state});
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        return this.equals((Oid_Root)other);
    }

    public boolean equals(Oid_Root other) {
        return Objects.equals(this.objectSpecId, other.getObjectSpecId()) && Objects.equals(this.identifier, other.getIdentifier()) && Objects.equals((Object)this.state, (Object)other.state);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.enString();
    }

    @Override
    public Oid copy() {
        return Oid_Root.of(this.objectSpecId, this.identifier, this.state, this.version);
    }
}

