/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.adapter.oid;

import java.io.IOException;
import java.util.Objects;
import org.apache.isis.commons.internal.base._With;
import org.apache.isis.core.commons.encoding.DataInputExtended;
import org.apache.isis.core.commons.encoding.DataOutputExtended;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.adapter.oid.ParentedOid;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.adapter.version.Version;

final class Oid_Parented
implements ParentedOid {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final int hashCode;
    private final RootOid parentRootOid;

    static Oid_Parented ofName(RootOid parentRootOid, String name) {
        return new Oid_Parented(parentRootOid, name);
    }

    private Oid_Parented(RootOid parentRootOid, String name) {
        _With.requires((Object)parentRootOid, (String)"parentRootOid");
        this.parentRootOid = parentRootOid;
        this.name = name;
        this.hashCode = this.calculateHash();
    }

    @Override
    public RootOid getParentOid() {
        return this.parentRootOid;
    }

    @Override
    public Version getVersion() {
        return this.parentRootOid.getVersion();
    }

    @Override
    public void setVersion(Version version) {
        this.parentRootOid.setVersion(version);
    }

    @Override
    public boolean isTransient() {
        return this.getParentOid().isTransient();
    }

    @Override
    public boolean isViewModel() {
        return this.getParentOid().isViewModel();
    }

    @Override
    public boolean isPersistent() {
        return this.getParentOid().isPersistent();
    }

    public static Oid_Parented deString(String oidStr) {
        return Oid.unmarshaller().unmarshal(oidStr, Oid_Parented.class);
    }

    @Override
    public String enString() {
        return Oid.marshaller().marshal(this);
    }

    @Override
    public String enStringNoVersion() {
        return Oid.marshaller().marshalNoVersion(this);
    }

    public Oid_Parented(DataInputExtended inputStream) throws IOException {
        this(Oid_Parented.deString(inputStream.readUTF()));
    }

    private Oid_Parented(Oid_Parented oid) throws IOException {
        this.parentRootOid = oid.getParentOid();
        this.name = oid.name;
        this.hashCode = this.calculateHash();
    }

    public void encode(DataOutputExtended outputStream) throws IOException {
        outputStream.writeUTF(this.enString());
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.enString();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        return this.equals((Oid_Parented)other);
    }

    public boolean equals(Oid_Parented other) {
        return Objects.equals(other.getParentOid(), this.getParentOid()) && Objects.equals(other.name, this.name);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int calculateHash() {
        return Objects.hash(this.getParentOid(), this.name);
    }

    public Oid_Parented asPersistent(RootOid newParentRootOid) {
        return new Oid_Parented(newParentRootOid, this.name);
    }

    @Override
    public Oid copy() {
        return Oid_Parented.ofName((RootOid)this.parentRootOid.copy(), this.name);
    }
}

