/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.adapter;

import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.commons.internal.base._With;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;

public interface ObjectAdapterProvider {
    @Programmatic
    @Nullable
    default public Oid oidFor(@Nullable Object domainObject) {
        return (Oid)_With.mapIfPresentElse((Object)this.adapterFor(domainObject), ObjectAdapter::getOid, null);
    }

    @Nullable
    public ObjectAdapter adapterFor(@Nullable Object var1);

    public ObjectAdapter adapterFor(Object var1, RootOid var2, OneToManyAssociation var3);

    public ManagedObject disposableAdapterForViewModel(Object var1);

    public ObjectSpecification specificationForViewModel(Object var1);

    public ObjectAdapter adapterForViewModel(Object var1, String var2);

    public ObjectAdapter newTransientInstance(ObjectSpecification var1);

    @Nullable
    public ObjectAdapter recreateViewModelInstance(ObjectSpecification var1, @Nullable String var2);

    public Stream<ObjectAdapter> streamServices();

    public ObjectAdapter lookupService(String var1);

    public static interface Delegating
    extends ObjectAdapterProvider {
        @Programmatic
        public ObjectAdapterProvider getObjectAdapterProvider();

        @Override
        @Programmatic
        default public ObjectAdapter adapterFor(Object domainObject) {
            return this.getObjectAdapterProvider().adapterFor(domainObject);
        }

        @Override
        @Programmatic
        default public ObjectAdapter adapterFor(Object pojo, RootOid parentOid, OneToManyAssociation collection) {
            return this.getObjectAdapterProvider().adapterFor(pojo, parentOid, collection);
        }

        @Override
        @Programmatic
        default public ManagedObject disposableAdapterForViewModel(Object viewModelPojo) {
            return this.getObjectAdapterProvider().disposableAdapterForViewModel(viewModelPojo);
        }

        @Override
        @Programmatic
        default public ObjectSpecification specificationForViewModel(Object viewModelPojo) {
            return this.getObjectAdapterProvider().specificationForViewModel(viewModelPojo);
        }

        @Override
        @Programmatic
        default public ObjectAdapter adapterForViewModel(Object viewModelPojo, String mementoString) {
            return this.getObjectAdapterProvider().adapterForViewModel(viewModelPojo, mementoString);
        }

        @Override
        @Programmatic
        default public ObjectAdapter newTransientInstance(ObjectSpecification objectSpec) {
            return this.getObjectAdapterProvider().newTransientInstance(objectSpec);
        }

        @Override
        @Programmatic
        default public ObjectAdapter recreateViewModelInstance(ObjectSpecification objectSpec, String memento) {
            return this.getObjectAdapterProvider().recreateViewModelInstance(objectSpec, memento);
        }

        @Override
        @Programmatic
        default public Stream<ObjectAdapter> streamServices() {
            return this.getObjectAdapterProvider().streamServices();
        }

        @Override
        @Programmatic
        default public ObjectAdapter lookupService(String serviceId) {
            return this.getObjectAdapterProvider().lookupService(serviceId);
        }
    }
}

