/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.metamodel.adapter;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.commons.internal.base._Tuples;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.core.commons.lang.ClassExtensions;
import org.apache.isis.core.commons.lang.ListExtensions;
import org.apache.isis.core.commons.lang.MethodExtensions;
import org.apache.isis.core.commons.lang.MethodUtil;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.adapter.oid.ParentedOid;
import org.apache.isis.core.metamodel.adapter.version.Version;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.consent.InteractionResult;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionFacet;
import org.apache.isis.core.metamodel.interactions.InteractionUtils;
import org.apache.isis.core.metamodel.interactions.ObjectVisibilityContext;
import org.apache.isis.core.metamodel.interactions.VisibilityContext;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;

public interface ObjectAdapter
extends ManagedObject {
    public void checkLock(Version var1);

    public Oid getOid();

    public ObjectAdapter getAggregateRoot();

    public Version getVersion();

    public void setVersion(Version var1);

    default public boolean isParentedCollection() {
        return this.getOid() instanceof ParentedOid;
    }

    default public boolean isValue() {
        return this.getOid().isValue();
    }

    public boolean isTransient();

    public boolean representsPersistent();

    public boolean isDestroyed();

    public static final class InvokeUtils {
        private InvokeUtils() {
        }

        public static void invokeAll(Collection<Method> methods, ManagedObject adapter) {
            MethodUtil.invoke(methods, Util.unwrapPojo(adapter));
        }

        public static Object invoke(Method method, ManagedObject adapter) {
            return MethodExtensions.invoke(method, Util.unwrapPojo(adapter));
        }

        public static Object invoke(Method method, ManagedObject adapter, Object arg0) {
            return MethodExtensions.invoke(method, Util.unwrapPojo(adapter), new Object[]{arg0});
        }

        public static Object invoke(Method method, ManagedObject adapter, ManagedObject arg0Adapter) {
            return InvokeUtils.invoke(method, adapter, Util.unwrapPojo(arg0Adapter));
        }

        public static Object invoke(Method method, ManagedObject adapter, ManagedObject[] argumentAdapters) {
            return MethodExtensions.invoke(method, Util.unwrapPojo(adapter), Util.unwrapPojoArray(argumentAdapters));
        }

        public static Object invokeC(Method method, ManagedObject adapter, Stream<_Tuples.Tuple2<Integer, ? extends ManagedObject>> paramsAndIndexes) {
            return InvokeUtils.invoke(method, adapter, InvokeUtils.asArray(paramsAndIndexes, method.getParameterTypes().length));
        }

        private static ManagedObject[] asArray(Stream<_Tuples.Tuple2<Integer, ? extends ManagedObject>> paramsAndIndexes, int length) {
            ManagedObject[] args = new ManagedObject[length];
            paramsAndIndexes.forEach(entry -> {
                Integer paramNum = (Integer)entry.get_1();
                if (paramNum < length) {
                    args[paramNum.intValue()] = (ManagedObject)entry.get_2();
                }
            });
            return args;
        }

        public static Object invokeAutofit(Method method, ManagedObject target, List<? extends ManagedObject> argumentsIfAvailable) {
            ArrayList args = _Lists.newArrayList();
            if (argumentsIfAvailable != null) {
                args.addAll(argumentsIfAvailable);
            }
            InvokeUtils.adjust(method, args);
            ManagedObject[] argArray = args.toArray(new ManagedObject[0]);
            return InvokeUtils.invoke(method, target, argArray);
        }

        private static void adjust(Method method, List<ManagedObject> args) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            ListExtensions.adjust(args, parameterTypes.length);
            for (int i = 0; i < parameterTypes.length; ++i) {
                Class<?> cls = parameterTypes[i];
                if (args.get(i) != null || !cls.isPrimitive()) continue;
                Object object = ClassExtensions.toDefault(cls);
                ManagedObject adapter = ManagedObject.of((ObjectSpecification)null, object);
                args.set(i, adapter);
            }
        }
    }

    public static final class Util {
        private Util() {
        }

        public static Object unwrapPojo(ManagedObject adapter) {
            return adapter != null ? adapter.getPojo() : null;
        }

        public static Object[] unwrapPojoArray(ManagedObject[] adapters) {
            if (adapters == null) {
                return null;
            }
            Object[] unwrappedObjects = new Object[adapters.length];
            int i = 0;
            for (ManagedObject adapter : adapters) {
                unwrappedObjects[i++] = Util.unwrapPojo(adapter);
            }
            return unwrappedObjects;
        }

        public static List<Object> unwrapPojoList(List<? extends ManagedObject> adapters) {
            ArrayList objects = _Lists.newArrayList();
            for (ManagedObject managedObject : adapters) {
                objects.add(Util.unwrapPojo(managedObject));
            }
            return objects;
        }

        public static <T> List<T> unwrapTypedPojoList(List<? extends ManagedObject> adapters) {
            return Util.unwrapPojoList(adapters);
        }

        public static String unwrapPojoStringElse(ManagedObject adapter, String orElse) {
            Object obj = Util.unwrapPojo(adapter);
            if (obj == null) {
                return null;
            }
            if (!(obj instanceof String)) {
                return orElse;
            }
            return (String)obj;
        }

        public static String titleString(ManagedObject adapter) {
            return adapter != null ? adapter.titleString(null) : "";
        }

        public static boolean exists(ManagedObject adapter) {
            return adapter != null && adapter.getPojo() != null;
        }

        public static boolean wrappedEqual(ManagedObject adapter1, ManagedObject adapter2) {
            boolean defined1 = Util.exists(adapter1);
            boolean defined2 = Util.exists(adapter2);
            if (defined1 && !defined2) {
                return false;
            }
            if (!defined1 && defined2) {
                return false;
            }
            if (!defined1 && !defined2) {
                return true;
            }
            return adapter1.getPojo().equals(adapter2.getPojo());
        }

        public static boolean nullSafeEquals(Object obj1, Object obj2) {
            if (obj1 == null && obj2 == null) {
                return true;
            }
            if (obj1 == null || obj2 == null) {
                return false;
            }
            if (obj1.equals(obj2)) {
                return true;
            }
            if (obj1 instanceof ManagedObject && obj2 instanceof ManagedObject) {
                ManagedObject adapterObj1 = (ManagedObject)obj1;
                ManagedObject adapterObj2 = (ManagedObject)obj2;
                return Util.nullSafeEquals(adapterObj1.getPojo(), adapterObj2.getPojo());
            }
            return false;
        }

        public static List<ObjectAdapter> visibleAdapters(ObjectAdapter collectionAdapter, InteractionInitiatedBy interactionInitiatedBy) {
            Stream<ObjectAdapter> objectAdapters = CollectionFacet.Utils.streamAdapters(collectionAdapter);
            return Util.visibleAdapters(objectAdapters, interactionInitiatedBy);
        }

        public static List<ObjectAdapter> visibleAdapters(Iterable<ObjectAdapter> objectAdapters, InteractionInitiatedBy interactionInitiatedBy) {
            ArrayList adapters = _Lists.newArrayList();
            for (ObjectAdapter adapter : objectAdapters) {
                boolean visible = Util.isVisible(adapter, interactionInitiatedBy);
                if (!visible) continue;
                adapters.add(adapter);
            }
            return adapters;
        }

        public static List<ObjectAdapter> visibleAdapters(Stream<ObjectAdapter> objectAdapters, InteractionInitiatedBy interactionInitiatedBy) {
            return objectAdapters.filter(adapter -> Util.isVisible(adapter, interactionInitiatedBy)).collect(Collectors.toList());
        }

        public static boolean isVisible(ObjectAdapter adapter, InteractionInitiatedBy interactionInitiatedBy) {
            if (adapter == null) {
                return true;
            }
            if (adapter.isDestroyed()) {
                return false;
            }
            if (interactionInitiatedBy == InteractionInitiatedBy.FRAMEWORK) {
                return true;
            }
            return Util.isVisibleForUser(adapter);
        }

        private static boolean isVisibleForUser(ObjectAdapter adapter) {
            VisibilityContext<?> context = Util.createVisibleInteractionContextForUser(adapter);
            ObjectSpecification objectSpecification = adapter.getSpecification();
            InteractionResult visibleResult = InteractionUtils.isVisibleResult(objectSpecification, context);
            return visibleResult.isNotVetoing();
        }

        private static VisibilityContext<?> createVisibleInteractionContextForUser(ObjectAdapter objectAdapter) {
            return new ObjectVisibilityContext(objectAdapter, objectAdapter.getSpecification().getIdentifier(), InteractionInitiatedBy.USER, Where.OBJECT_FORMS);
        }
    }
}

