/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.commons.reflection;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class Reflect {
    public static Object[] emptyObjects = new Object[0];
    public static Class<?>[] emptyClasses = new Class[0];
    private static final Set<Class<?>> primitives = new HashSet<Class>(Arrays.asList(Boolean.TYPE, Byte.TYPE, Character.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE));
    private static final Set<Class<?>> primitiveWrappers = new HashSet<Class>(Arrays.asList(Boolean.class, Byte.class, Character.class, Double.class, Float.class, Integer.class, Long.class, Short.class));

    public static List<Method> getAllDeclaredMethods(Class<?> type) {
        ArrayList<Method> methods = new ArrayList<Method>();
        Stream.of(type.getDeclaredMethods()).forEach(methods::add);
        Reflect.visitInterfaces(type, c -> Stream.of(c.getDeclaredMethods()).forEach(methods::add));
        Reflect.visitSuperclassesOf(type, c -> Stream.of(c.getDeclaredMethods()).forEach(methods::add));
        return methods;
    }

    public static List<Field> getAllDeclaredFields(Class<?> type) {
        ArrayList<Field> fields = new ArrayList<Field>();
        Stream.of(type.getDeclaredFields()).forEach(fields::add);
        Reflect.visitInterfaces(type, c -> Stream.of(c.getDeclaredFields()).forEach(fields::add));
        Reflect.visitSuperclassesOf(type, c -> Stream.of(c.getDeclaredFields()).forEach(fields::add));
        return fields;
    }

    public static void visitSuperclassesOf(Class<?> clazz, Consumer<Class<?>> visitor) {
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null) {
            visitor.accept(superclass);
            Reflect.visitSuperclassesOf(superclass, visitor);
        }
    }

    public static void visitInterfaces(Class<?> clazz, Consumer<Class<?>> visitor) {
        if (clazz.isInterface()) {
            visitor.accept(clazz);
        }
        for (Class<?> interf : clazz.getInterfaces()) {
            visitor.accept(interf);
        }
    }

    public static Method getGetter(Class<?> cls, String propertyName) throws IntrospectionException {
        BeanInfo beanInfo = Introspector.getBeanInfo(cls);
        for (PropertyDescriptor pd : beanInfo.getPropertyDescriptors()) {
            if (!pd.getName().equals(propertyName)) continue;
            return pd.getReadMethod();
        }
        return null;
    }

    public static Method getGetter(Object bean, String propertyName) throws IntrospectionException {
        if (bean == null) {
            return null;
        }
        return Reflect.getGetter(bean, propertyName);
    }

    public static MethodHandle handleOf(Method method) throws IllegalAccessException {
        if (!method.isAccessible()) {
            method.setAccessible(true);
            MethodHandle mh = MethodHandles.publicLookup().unreflect(method);
            method.setAccessible(false);
            return mh;
        }
        return MethodHandles.publicLookup().unreflect(method);
    }

    public static MethodHandle handleOf(Field field) throws IllegalAccessException {
        if (!field.isAccessible()) {
            field.setAccessible(true);
            MethodHandle mh = MethodHandles.lookup().unreflectGetter(field);
            field.setAccessible(false);
            return mh;
        }
        return MethodHandles.lookup().unreflectGetter(field);
    }

    public static boolean isVoid(Class<?> c) {
        Objects.requireNonNull(c);
        return c == Void.TYPE || c == Void.class;
    }

    public static boolean isPrimitive(Class<?> c) {
        Objects.requireNonNull(c);
        return primitives.contains(c);
    }

    public static boolean isPrimitiveWrapper(Class<?> c) {
        Objects.requireNonNull(c);
        return primitiveWrappers.contains(c);
    }

    public static boolean isNoArg(Method m) {
        Objects.requireNonNull(m);
        return m.getParameterTypes().length == 0;
    }

    public static boolean isPublic(Method m) {
        Objects.requireNonNull(m);
        return Modifier.isPublic(m.getModifiers());
    }

    public static boolean isVoid(Method m) {
        Objects.requireNonNull(m);
        return Reflect.isVoid(m.getReturnType());
    }
}

