/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.commons.lang;

public final class Wormhole {
    private ThreadLocal<Boolean> inWormhole = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    private Wormhole() {
    }

    public void run(Runnable runnable) {
        try {
            if (this.inWormhole.get().booleanValue()) {
                return;
            }
            this.inWormhole.set(true);
            runnable.run();
        }
        finally {
            this.inWormhole.set(false);
        }
    }

    public static void invoke(Runnable runnable) {
        new Wormhole().run(runnable);
    }
}

