/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.commons.lang;

import java.lang.invoke.WrongMethodTypeException;
import java.lang.reflect.InvocationTargetException;
import java.util.function.Consumer;
import org.apache.isis.applib.RecoverableException;
import org.apache.isis.core.commons.exceptions.IsisApplicationException;
import org.apache.isis.core.metamodel.exceptions.MetaModelException;
import org.apache.isis.core.metamodel.specloader.ReflectiveActionException;

public final class ThrowableExtensions {
    public static Object handleInvocationException(Throwable e, String memberName) {
        return ThrowableExtensions.handleInvocationException(e, memberName, null);
    }

    public static Object handleInvocationException(Throwable e, String memberName, Consumer<RecoverableException> recovery) {
        if (e instanceof InvocationTargetException) {
            return ThrowableExtensions.handleInvocationException(((InvocationTargetException)e).getTargetException(), memberName, recovery);
        }
        if (e instanceof WrongMethodTypeException) {
            throw new MetaModelException("Wrong method type access of " + memberName, e);
        }
        if (e instanceof IllegalAccessException) {
            throw new ReflectiveActionException("Illegal access of " + memberName, e);
        }
        if (e instanceof IllegalStateException) {
            throw new ReflectiveActionException(String.format("IllegalStateException thrown while invoking %s %s", memberName, e.getMessage()), e);
        }
        if (e instanceof RecoverableException) {
            return ThrowableExtensions.handleRecoverableException((RecoverableException)e, memberName, recovery);
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new MetaModelException("Exception invoking " + memberName, e);
    }

    private static Object handleRecoverableException(RecoverableException e, String memberName, Consumer<RecoverableException> recovery) {
        if (recovery != null) {
            recovery.accept(e);
        }
        throw new IsisApplicationException("Exception invoking " + memberName, (Throwable)e);
    }
}

