/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.commons.lang;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.isis.commons.internal.context._Context;

public class ResourceUtil {
    private ResourceUtil() {
    }

    public static InputStream getResourceAsStream(String resource) {
        ClassLoader classLoader = _Context.getDefaultClassLoader();
        InputStream is = classLoader.getResourceAsStream(resource);
        if (is != null) {
            return is;
        }
        classLoader = Thread.currentThread().getContextClassLoader();
        is = classLoader.getResourceAsStream(resource);
        if (is != null) {
            return is;
        }
        classLoader = ResourceUtil.class.getClassLoader();
        is = classLoader.getResourceAsStream(resource);
        if (is != null) {
            return is;
        }
        try {
            return ClassLoader.getSystemResourceAsStream(resource);
        }
        catch (NullPointerException ignore) {
            return null;
        }
    }

    public static InputStream getResourceAsStream(HttpServletRequest request) {
        String realPath = request.getSession().getServletContext().getRealPath(request.getServletPath());
        if (realPath == null) {
            return null;
        }
        try {
            return new FileInputStream(realPath);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }
}

