/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.commons.lang;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.isis.commons.internal._Constants;
import org.apache.isis.core.commons.lang.ArrayExtensions;
import org.apache.isis.core.commons.lang.ClassExtensions;

public final class ObjectExtensions {
    private ObjectExtensions() {
    }

    public static <T> T asT(Object extendee) {
        return (T)extendee;
    }

    public static <T> List<T> asListT(Object extendee, Class<T> castTo) {
        return (List)extendee;
    }

    public static Object[] asArray(Object extendee) {
        Class<?> arrayType = extendee.getClass().getComponentType();
        if (!arrayType.isPrimitive()) {
            return (Object[])extendee;
        }
        if (arrayType == Character.TYPE) {
            return ArrayExtensions.asCharToCharacterArray(extendee);
        }
        return ArrayExtensions.convertPrimitiveToObjectArray(extendee, arrayType);
    }

    public static Method getMethod(Object object, String methodName, Class<?> ... parameterClass) throws NoSuchMethodException {
        return ClassExtensions.getMethod(object.getClass(), methodName, parameterClass);
    }

    public static Method getMethod(Object object, String methodName) throws NoSuchMethodException {
        return ClassExtensions.getMethod(object.getClass(), methodName, _Constants.emptyClasses);
    }

    public static String classBaseName(Object forObject) {
        String name = forObject.getClass().getName();
        return name.substring(name.lastIndexOf(46) + 1);
    }

    public static void appendToString(Object extendee, Appendable buf) {
        try {
            buf.append(ObjectExtensions.classBaseName(extendee));
            buf.append('@');
            buf.append(Integer.toHexString(extendee.hashCode()));
        }
        catch (IOException iox) {
            throw new RuntimeException("A problem occurred while appending an object to an appendable", iox);
        }
    }
}

