/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.commons.lang;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.collections._Arrays;
import org.apache.isis.commons.internal.collections._Collections;

public class MethodInvocationPreprocessor {
    public static Object invoke(Method method, Object targetPojo, Object[] executionParameters) throws IllegalAccessException, InvocationTargetException {
        if (_NullSafe.isEmpty((Object[])executionParameters)) {
            return method.invoke(targetPojo, executionParameters);
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        Object[] adaptedExecutionParameters = new Object[executionParameters.length];
        int i = 0;
        for (Object param : executionParameters) {
            adaptedExecutionParameters[i] = MethodInvocationPreprocessor.adapt(param, parameterTypes[i]);
            ++i;
        }
        try {
            return method.invoke(targetPojo, adaptedExecutionParameters);
        }
        catch (IllegalArgumentException e) {
            throw MethodInvocationPreprocessor.verboseArgumentException(parameterTypes, adaptedExecutionParameters, e);
        }
    }

    private static Object adapt(Object obj, Class<?> parameterType) {
        if (obj == null) {
            return null;
        }
        if (_Arrays.isArrayType(parameterType)) {
            Class componentType = _Arrays.inferComponentTypeIfAny(parameterType);
            if (componentType == null) {
                return obj;
            }
            List list = (List)obj;
            return _Arrays.toArray((Collection)((Collection)_Casts.uncheckedCast((Object)list)), (Class)componentType);
        }
        if (Collection.class.equals(parameterType)) {
            return _Collections.asUnmodifiableCollection((List)((List)obj));
        }
        if (List.class.equals(parameterType)) {
            return _Collections.asUnmodifiableList((List)((List)obj));
        }
        if (Set.class.equals(parameterType)) {
            return _Collections.asUnmodifiableSet((List)((List)obj));
        }
        if (SortedSet.class.equals(parameterType)) {
            return _Collections.asUnmodifiableSortedSet((List)((List)obj));
        }
        return obj;
    }

    private static IllegalArgumentException verboseArgumentException(Class<?>[] parameterTypes, Object[] adaptedExecutionParameters, IllegalArgumentException e) {
        StringBuilder sb = new StringBuilder();
        for (int j = 0; j < parameterTypes.length; ++j) {
            Class<?> parameterType = parameterTypes[j];
            Object parameterValue = adaptedExecutionParameters[j];
            sb.append(String.format("expected-param-type[%d]: %s, got %s\n", j, parameterType.getName(), parameterValue.getClass().getName()));
        }
        return new IllegalArgumentException(sb.toString(), e);
    }
}

