/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.commons.lang;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.core.commons.lang.ClassFunctions;
import org.apache.isis.core.commons.lang.ClassPredicates;

public final class ListExtensions {
    private static final String DEFAULT_DELIMITER = ",";

    private ListExtensions() {
    }

    public static <T> List<T> combineWith(List<T> extendee, List<T> list2) {
        ArrayList combinedList = _Lists.newArrayList();
        combinedList.addAll(extendee);
        combinedList.addAll(list2);
        return combinedList;
    }

    public static <T> List<T> mergeWith(List<T> extendee, List<T> list2) {
        for (T obj : list2) {
            if (extendee.contains(obj)) continue;
            extendee.add(obj);
        }
        return extendee;
    }

    public static List<String> appendDelimitedStringToList(String commaSeparated, List<String> list) {
        return ListExtensions.appendDelimitedStringToList(commaSeparated, DEFAULT_DELIMITER, list);
    }

    public static List<String> appendDelimitedStringToList(String delimited, String delimiter, List<String> list) {
        if (delimited == null) {
            return list;
        }
        String[] optionValues = delimited.split(delimiter);
        list.addAll(Arrays.asList(optionValues));
        return list;
    }

    public static <T> List<T> mutableCopy(List<T> input) {
        return _NullSafe.stream(input).collect(Collectors.toList());
    }

    public static <T> List<T> mutableCopy(T[] arr) {
        return _NullSafe.stream((Object[])arr).collect(Collectors.toList());
    }

    public static <T> void insert(List<T> list, int insertionPoint, T elementToInsert) {
        ListExtensions.extend(list, insertionPoint);
        list.add(insertionPoint, elementToInsert);
    }

    public static <T> void adjust(List<T> list, int requiredLength) {
        ListExtensions.extend(list, requiredLength);
        if (list.size() > requiredLength) {
            list.subList(requiredLength, list.size()).clear();
        }
    }

    private static <T> void extend(List<T> list, int requiredLength) {
        for (int i = list.size(); i < requiredLength; ++i) {
            list.add(null);
        }
    }

    public static <T> Collection<T> filtered(List<Object> extendee, Class<T> type) {
        return _NullSafe.stream(extendee).filter(ClassPredicates.isOfType(type)).map(ClassFunctions.castTo(type)).collect(Collectors.toList());
    }
}

