/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.commons.lang;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.commons.lang.ClassExtensions;

public final class ArrayExtensions {
    private ArrayExtensions() {
    }

    static Object[] convertPrimitiveToObjectArray(Object extendee, Class<?> arrayType) {
        Object[] convertedArray;
        try {
            Class<?> wrapperClass = ClassExtensions.asWrapped(arrayType);
            Constructor<?> constructor = wrapperClass.getConstructor(String.class);
            int len = Array.getLength(extendee);
            convertedArray = (Object[])Array.newInstance(wrapperClass, len);
            for (int i = 0; i < len; ++i) {
                convertedArray[i] = constructor.newInstance(Array.get(extendee, i).toString());
            }
        }
        catch (NoSuchMethodException e) {
            throw new IsisException((Throwable)e);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IsisException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new IsisException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new IsisException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new IsisException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new IsisException((Throwable)e);
        }
        return convertedArray;
    }

    public static Object[] asCharToCharacterArray(Object extendee) {
        char[] original = (char[])extendee;
        int len = original.length;
        Object[] converted = new Character[len];
        for (int i = 0; i < converted.length; ++i) {
            converted[i] = Character.valueOf(original[i]);
        }
        return converted;
    }

    @SafeVarargs
    public static <T> T[] combine(T[] ... arrays) {
        ArrayList combinedList = _Lists.newArrayList();
        for (T[] array : arrays) {
            Collections.addAll(combinedList, array);
        }
        return combinedList.toArray(arrays[0]);
    }

    public static <T> T[] appendT(T[] array, T obj) {
        ArrayList combinedList = _Lists.newArrayList();
        combinedList.add(obj);
        Collections.addAll(combinedList, array);
        return combinedList.toArray(array);
    }

    public static String[] append(String[] extendee, String ... moreArgs) {
        ArrayList argList = _Lists.newArrayList();
        argList.addAll(Arrays.asList(extendee));
        argList.addAll(Arrays.asList(moreArgs));
        return argList.toArray(new String[0]);
    }

    @SafeVarargs
    public static <T> T coalesce(T ... objects) {
        for (T object : objects) {
            if (object == null) continue;
            return object;
        }
        return null;
    }
}

