/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.commons.ensure;

import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.isis.commons.internal.base._With;

public final class Ensure {
    private Ensure() {
    }

    public static void ensure(String expectation, boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException("illegal argument, expected: " + expectation);
        }
    }

    public static <T> T ensureThatArg(T arg, Predicate<T> predicate, String message) {
        _With.requires(predicate, (String)"predicate");
        if (!predicate.test(arg)) {
            throw new IllegalArgumentException(message);
        }
        return arg;
    }

    public static <T> T ensureThatArg(T arg, Predicate<T> predicate, Supplier<String> messageSupplier) {
        _With.requires(predicate, (String)"predicate");
        if (!predicate.test(arg)) {
            _With.requires(messageSupplier, (String)"messageSupplier");
            throw new IllegalArgumentException(messageSupplier.get());
        }
        return arg;
    }

    public static <T> T ensureThatState(T field, Predicate<T> predicate, String message) {
        _With.requires(predicate, (String)"predicate");
        if (!predicate.test(field)) {
            throw new IllegalStateException(message);
        }
        return field;
    }

    public static <T> T ensureThatContext(T contextProperty, Predicate<T> predicate, String message) {
        _With.requires(predicate, (String)"predicate");
        if (!predicate.test(contextProperty)) {
            throw new IllegalThreadStateException(message);
        }
        return contextProperty;
    }
}

