/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.commons.encoding;

import java.io.IOException;
import org.apache.isis.core.commons.encoding.DataOutputExtended;
import org.apache.isis.core.commons.encoding.DataOutputExtendedDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugDataOutputExtended
extends DataOutputExtendedDecorator {
    private static final Logger LOG = LoggerFactory.getLogger(DebugDataOutputExtended.class);

    public DebugDataOutputExtended(DataOutputExtended underlying) {
        super(underlying);
    }

    @Override
    public void writeBoolean(boolean flag) throws IOException {
        LOG.debug("boolean: {}", (Object)flag);
        super.writeBoolean(flag);
    }

    @Override
    public void writeBytes(byte[] value) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("bytes: ({}) {}", (Object)value.length, (Object)new String(value));
        }
        super.writeBytes(value);
    }

    @Override
    public void writeByte(int value) throws IOException {
        LOG.debug("byte: {}", (Object)value);
        super.writeByte(value);
    }

    @Override
    public void writeInt(int value) throws IOException {
        LOG.debug("int: {}", (Object)value);
        super.writeInt(value);
    }

    @Override
    public void writeLong(long value) throws IOException {
        LOG.debug("long: {}", (Object)value);
        super.writeLong(value);
    }

    @Override
    public void writeEncodable(Object object) throws IOException {
        LOG.debug(">>> object: ({})", object);
        super.writeEncodable(object);
    }

    @Override
    public void writeEncodables(Object[] objects) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">>> objects x{}", (Object)objects.length);
        }
        super.writeEncodables(objects);
    }

    @Override
    public void writeUTF(String str) throws IOException {
        LOG.debug("string: {}", (Object)str);
        super.writeUTF(str);
    }

    @Override
    public void writeUTFs(String[] strings) throws IOException {
        if (LOG.isDebugEnabled()) {
            StringBuffer l = new StringBuffer();
            for (int i = 0; i < strings.length; ++i) {
                if (i > 0) {
                    l.append(", ");
                }
                l.append(strings[i]);
            }
            LOG.debug("list: {}", (Object)l);
        }
        super.writeUTFs(strings);
    }
}

