/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.common.parser;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.iotdb.db.qp.sql.PathParser;
import org.apache.iotdb.db.qp.sql.PathParserBaseVisitor;
import org.apache.iotdb.tsfile.common.constant.TsFileConstant;

public class PathVisitor
extends PathParserBaseVisitor<String[]> {
    public String[] visitPath(PathParser.PathContext ctx) {
        if (ctx.prefixPath() != null) {
            return this.visitPrefixPath(ctx.prefixPath());
        }
        return this.visitSuffixPath(ctx.suffixPath());
    }

    public String[] visitPrefixPath(PathParser.PrefixPathContext ctx) {
        List nodeNames = ctx.nodeName();
        String[] path = new String[nodeNames.size() + 1];
        path[0] = ctx.ROOT().getText();
        for (int i = 0; i < nodeNames.size(); ++i) {
            path[i + 1] = this.parseNodeName((PathParser.NodeNameContext)nodeNames.get(i));
        }
        return path;
    }

    public String[] visitSuffixPath(PathParser.SuffixPathContext ctx) {
        List nodeNames = ctx.nodeName();
        String[] path = new String[nodeNames.size()];
        for (int i = 0; i < nodeNames.size(); ++i) {
            path[i] = this.parseNodeName((PathParser.NodeNameContext)nodeNames.get(i));
        }
        return path;
    }

    private String parseNodeName(PathParser.NodeNameContext ctx) {
        String nodeName = ctx.getText();
        if (nodeName.startsWith("`") && nodeName.endsWith("`")) {
            String unWrapped = nodeName.substring(1, nodeName.length() - 1);
            if (StringUtils.isNumeric((CharSequence)unWrapped) || !TsFileConstant.IDENTIFIER_PATTERN.matcher(unWrapped).matches()) {
                return nodeName;
            }
            return unWrapped;
        }
        return nodeName;
    }
}

