/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hive;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.FunctionType;
import org.apache.hadoop.hive.metastore.api.GetAllFunctionsResponse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.hive.HiveClientPool;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.thrift.transport.TTransportException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestHiveClientPool {
    private static final String HIVE_SITE_CONTENT = "<?xml version=\"1.0\"?>\n<?xml-stylesheet type=\"text/xsl\" href=\"configuration.xsl\"?>\n<configuration>\n  <property>\n    <name>hive.metastore.sasl.enabled</name>\n    <value>true</value>\n  </property>\n</configuration>\n";
    HiveClientPool clients;

    @Before
    public void before() {
        HiveClientPool clientPool = new HiveClientPool(2, new Configuration());
        this.clients = (HiveClientPool)Mockito.spy((Object)clientPool);
    }

    @After
    public void after() {
        this.clients.close();
        this.clients = null;
    }

    @Test
    public void testConf() {
        HiveConf conf = this.createHiveConf();
        conf.set(HiveConf.ConfVars.METASTOREWAREHOUSE.varname, "file:/mywarehouse/");
        HiveClientPool clientPool = new HiveClientPool(10, (Configuration)conf);
        HiveConf clientConf = clientPool.hiveConf();
        Assert.assertEquals((Object)conf.get(HiveConf.ConfVars.METASTOREWAREHOUSE.varname), (Object)clientConf.get(HiveConf.ConfVars.METASTOREWAREHOUSE.varname));
        Assert.assertEquals((long)10L, (long)clientPool.poolSize());
        Assert.assertEquals((Object)conf.get(HiveConf.ConfVars.METASTORE_USE_THRIFT_SASL.varname), (Object)clientConf.get(HiveConf.ConfVars.METASTORE_USE_THRIFT_SASL.varname));
        Assert.assertTrue((boolean)clientConf.getBoolVar(HiveConf.ConfVars.METASTORE_USE_THRIFT_SASL));
    }

    private HiveConf createHiveConf() {
        HiveConf hiveConf = new HiveConf();
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(HIVE_SITE_CONTENT.getBytes(StandardCharsets.UTF_8));){
            hiveConf.addResource((InputStream)inputStream, "for_test");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return hiveConf;
    }

    @Test
    public void testNewClientFailure() {
        ((HiveClientPool)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Connection exception")}).when((Object)this.clients)).newClient();
        AssertHelpers.assertThrows((String)"Should throw exception", RuntimeException.class, (String)"Connection exception", () -> (String)this.clients.run(Object::toString));
    }

    @Test
    public void testGetTablesFailsForNonReconnectableException() throws Exception {
        HiveMetaStoreClient hmsClient = (HiveMetaStoreClient)Mockito.mock(HiveMetaStoreClient.class);
        ((HiveClientPool)Mockito.doReturn((Object)hmsClient).when((Object)this.clients)).newClient();
        ((HiveMetaStoreClient)Mockito.doThrow((Throwable[])new Throwable[]{new MetaException("Another meta exception")}).when((Object)hmsClient)).getTables(Mockito.anyString(), Mockito.anyString());
        AssertHelpers.assertThrows((String)"Should throw exception", MetaException.class, (String)"Another meta exception", () -> (List)this.clients.run(client -> client.getTables("default", "t")));
    }

    @Test
    public void testConnectionFailureRestoreForMetaException() throws Exception {
        HiveMetaStoreClient hmsClient = this.newClient();
        String metaMessage = "Got exception: org.apache.thrift.transport.TTransportException";
        ((HiveMetaStoreClient)Mockito.doThrow((Throwable[])new Throwable[]{new MetaException(metaMessage)}).when((Object)hmsClient)).getAllDatabases();
        HiveMetaStoreClient newClient = this.reconnect(hmsClient);
        ArrayList databases = Lists.newArrayList((Object[])new String[]{"db1", "db2"});
        ((HiveMetaStoreClient)Mockito.doReturn((Object)databases).when((Object)newClient)).getAllDatabases();
        Assert.assertEquals((Object)databases, (Object)this.clients.run(client -> client.getAllDatabases(), true));
        ((HiveClientPool)Mockito.verify((Object)this.clients)).reconnect((IMetaStoreClient)hmsClient);
        ((HiveClientPool)Mockito.verify((Object)this.clients, (VerificationMode)Mockito.never())).reconnect((IMetaStoreClient)newClient);
    }

    @Test
    public void testConnectionFailureRestoreForTTransportException() throws Exception {
        HiveMetaStoreClient hmsClient = this.newClient();
        ((HiveMetaStoreClient)Mockito.doThrow((Throwable[])new Throwable[]{new TTransportException()}).when((Object)hmsClient)).getAllFunctions();
        HiveMetaStoreClient newClient = this.reconnect(hmsClient);
        GetAllFunctionsResponse response = new GetAllFunctionsResponse();
        response.addToFunctions(new Function("concat", "db1", "classname", "root", PrincipalType.USER, 100, FunctionType.JAVA, null));
        ((HiveMetaStoreClient)Mockito.doReturn((Object)response).when((Object)newClient)).getAllFunctions();
        Assert.assertEquals((Object)response, (Object)this.clients.run(client -> client.getAllFunctions(), true));
        ((HiveClientPool)Mockito.verify((Object)this.clients)).reconnect((IMetaStoreClient)hmsClient);
        ((HiveClientPool)Mockito.verify((Object)this.clients, (VerificationMode)Mockito.never())).reconnect((IMetaStoreClient)newClient);
    }

    private HiveMetaStoreClient newClient() {
        HiveMetaStoreClient hmsClient = (HiveMetaStoreClient)Mockito.mock(HiveMetaStoreClient.class);
        ((HiveClientPool)Mockito.doReturn((Object)hmsClient).when((Object)this.clients)).newClient();
        return hmsClient;
    }

    private HiveMetaStoreClient reconnect(HiveMetaStoreClient obsoleteClient) {
        HiveMetaStoreClient newClient = (HiveMetaStoreClient)Mockito.mock(HiveMetaStoreClient.class);
        ((HiveClientPool)Mockito.doReturn((Object)newClient).when((Object)this.clients)).reconnect((IMetaStoreClient)obsoleteClient);
        return newClient;
    }
}

