/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hive;

import java.io.File;
import java.io.IOException;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.iceberg.AssertHelpers;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.Files;
import org.apache.iceberg.HasTableOperations;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadataParser;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.exceptions.NotFoundException;
import org.apache.iceberg.hadoop.HadoopCatalog;
import org.apache.iceberg.hive.HiveTableBaseTest;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.thrift.TException;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class HiveTableTest
extends HiveTableBaseTest {
    static final String NON_DEFAULT_DATABASE = "nondefault";
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();

    @Test
    public void testCreate() throws TException {
        String tableName = TABLE_IDENTIFIER.name();
        org.apache.hadoop.hive.metastore.api.Table table = metastoreClient.getTable(TABLE_IDENTIFIER.namespace().level(0), tableName);
        Map parameters = table.getParameters();
        Assert.assertNotNull((Object)parameters);
        Assert.assertTrue((boolean)"iceberg".equalsIgnoreCase((String)parameters.get("table_type")));
        Assert.assertTrue((boolean)"EXTERNAL_TABLE".equalsIgnoreCase(table.getTableType()));
        Assert.assertEquals((Object)HiveTableTest.getTableLocation(tableName), (Object)table.getSd().getLocation());
        Assert.assertEquals((long)0L, (long)table.getPartitionKeysSize());
        Assert.assertEquals((long)1L, (long)HiveTableTest.metadataVersionFiles(tableName).size());
        Assert.assertEquals((long)0L, (long)HiveTableTest.manifestFiles(tableName).size());
        Table icebergTable = catalog.loadTable(TABLE_IDENTIFIER);
        Assert.assertEquals((Object)schema.asStruct(), (Object)icebergTable.schema().asStruct());
    }

    @Test
    public void testRename() {
        String renamedTableName = "rename_table_name";
        TableIdentifier renameTableIdentifier = TableIdentifier.of((Namespace)TABLE_IDENTIFIER.namespace(), (String)renamedTableName);
        Table original = catalog.loadTable(TABLE_IDENTIFIER);
        catalog.renameTable(TABLE_IDENTIFIER, renameTableIdentifier);
        Assert.assertFalse((boolean)catalog.tableExists(TABLE_IDENTIFIER));
        Assert.assertTrue((boolean)catalog.tableExists(renameTableIdentifier));
        Table renamed = catalog.loadTable(renameTableIdentifier);
        Assert.assertEquals((Object)original.schema().asStruct(), (Object)renamed.schema().asStruct());
        Assert.assertEquals((Object)original.spec(), (Object)renamed.spec());
        Assert.assertEquals((Object)original.location(), (Object)renamed.location());
        Assert.assertEquals((Object)original.currentSnapshot(), (Object)renamed.currentSnapshot());
        Assert.assertTrue((boolean)catalog.dropTable(renameTableIdentifier));
    }

    @Test
    public void testDrop() {
        Assert.assertTrue((String)"Table should exist", (boolean)catalog.tableExists(TABLE_IDENTIFIER));
        Assert.assertTrue((String)"Drop should return true and drop the table", (boolean)catalog.dropTable(TABLE_IDENTIFIER));
        Assert.assertFalse((String)"Table should not exist", (boolean)catalog.tableExists(TABLE_IDENTIFIER));
    }

    @Test
    public void testDropWithoutPurgeLeavesTableData() throws IOException {
        Table table = catalog.loadTable(TABLE_IDENTIFIER);
        String fileLocation = this.appendData(table, "file");
        String manifestListLocation = table.currentSnapshot().manifestListLocation().replace("file:", "");
        Assert.assertTrue((String)"Drop should return true and drop the table", (boolean)catalog.dropTable(TABLE_IDENTIFIER, false));
        Assert.assertFalse((String)"Table should not exist", (boolean)catalog.tableExists(TABLE_IDENTIFIER));
        Assert.assertTrue((String)"Table data files should exist", (boolean)new File(fileLocation).exists());
        Assert.assertTrue((String)"Table metadata files should exist", (boolean)new File(manifestListLocation).exists());
    }

    @Test
    public void testDropTable() throws IOException {
        Table table = catalog.loadTable(TABLE_IDENTIFIER);
        GenericRecordBuilder recordBuilder = new GenericRecordBuilder(AvroSchemaUtil.convert((Schema)schema, (String)"test"));
        ArrayList records = Lists.newArrayList((Object[])new GenericData.Record[]{recordBuilder.set("id", (Object)1L).build(), recordBuilder.set("id", (Object)2L).build(), recordBuilder.set("id", (Object)3L).build()});
        String location1 = table.location().replace("file:", "") + "/data/file1.avro";
        try (FileAppender writer = Avro.write((OutputFile)Files.localOutput((String)location1)).schema(schema).named("test").build();){
            for (Object rec : records) {
                writer.add(rec);
            }
        }
        String location2 = table.location().replace("file:", "") + "/data/file2.avro";
        Object object = null;
        try (FileAppender writer = Avro.write((OutputFile)Files.localOutput((String)location2)).schema(schema).named("test").build();){
            for (GenericData.Record rec : records) {
                writer.add((Object)rec);
            }
        }
        catch (Throwable rec) {
            object = rec;
            throw rec;
        }
        DataFile file1 = DataFiles.builder((PartitionSpec)table.spec()).withRecordCount(3L).withPath(location1).withFileSizeInBytes(Files.localInput((String)location2).getLength()).build();
        DataFile file2 = DataFiles.builder((PartitionSpec)table.spec()).withRecordCount(3L).withPath(location2).withFileSizeInBytes(Files.localInput((String)location1).getLength()).build();
        table.newAppend().appendFile(file1).appendFile(file2).commit();
        table.newDelete().deleteFile(file2.path()).commit();
        String manifestListLocation = table.currentSnapshot().manifestListLocation().replace("file:", "");
        List manifests = table.currentSnapshot().allManifests(table.io());
        Assert.assertTrue((String)"Drop (table and data) should return true and drop the table", (boolean)catalog.dropTable(TABLE_IDENTIFIER));
        Assert.assertFalse((String)"Table should not exist", (boolean)catalog.tableExists(TABLE_IDENTIFIER));
        Assert.assertFalse((String)"Table data files should not exist", (boolean)new File(location1).exists());
        Assert.assertFalse((String)"Table data files should not exist", (boolean)new File(location2).exists());
        Assert.assertFalse((String)"Table manifest list files should not exist", (boolean)new File(manifestListLocation).exists());
        for (ManifestFile manifest : manifests) {
            Assert.assertFalse((String)"Table manifest files should not exist", (boolean)new File(manifest.path().replace("file:", "")).exists());
        }
        Assert.assertFalse((String)"Table metadata file should not exist", (boolean)new File(((HasTableOperations)table).operations().current().metadataFileLocation().replace("file:", "")).exists());
    }

    @Test
    public void testExistingTableUpdate() throws TException {
        Table icebergTable = catalog.loadTable(TABLE_IDENTIFIER);
        icebergTable.updateSchema().addColumn("data", (Type)Types.LongType.get()).commit();
        icebergTable = catalog.loadTable(TABLE_IDENTIFIER);
        Assert.assertEquals((long)2L, (long)HiveTableTest.metadataVersionFiles("tbl").size());
        Assert.assertEquals((long)0L, (long)HiveTableTest.manifestFiles("tbl").size());
        Assert.assertEquals((Object)altered.asStruct(), (Object)icebergTable.schema().asStruct());
        org.apache.hadoop.hive.metastore.api.Table table = metastoreClient.getTable("hivedb", "tbl");
        List hiveColumns = table.getSd().getCols().stream().map(FieldSchema::getName).collect(Collectors.toList());
        List icebergColumns = altered.columns().stream().map(Types.NestedField::name).collect(Collectors.toList());
        Assert.assertEquals(icebergColumns, hiveColumns);
    }

    @Test
    public void testColumnTypeChangeInMetastore() throws TException {
        Table icebergTable = catalog.loadTable(TABLE_IDENTIFIER);
        Schema expectedSchema = new Schema(Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.LongType.get()), Types.NestedField.optional((int)3, (String)"string", (Type)Types.StringType.get()), Types.NestedField.optional((int)4, (String)"int", (Type)Types.IntegerType.get())}).fields());
        icebergTable.updateSchema().addColumn("data", (Type)Types.LongType.get()).addColumn("string", (Type)Types.StringType.get()).addColumn("int", (Type)Types.IntegerType.get()).commit();
        Assert.assertEquals((String)"Schema should match expected", (Object)expectedSchema.asStruct(), (Object)icebergTable.schema().asStruct());
        expectedSchema = new Schema(Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.LongType.get()), Types.NestedField.optional((int)4, (String)"int", (Type)Types.IntegerType.get())}).fields());
        icebergTable.updateSchema().deleteColumn("string").commit();
        Assert.assertEquals((String)"Schema should match expected", (Object)expectedSchema.asStruct(), (Object)icebergTable.schema().asStruct());
    }

    @Test(expected=CommitFailedException.class)
    public void testFailure() throws TException {
        Table icebergTable = catalog.loadTable(TABLE_IDENTIFIER);
        org.apache.hadoop.hive.metastore.api.Table table = metastoreClient.getTable("hivedb", "tbl");
        String dummyLocation = "dummylocation";
        table.getParameters().put("metadata_location", dummyLocation);
        metastoreClient.alter_table("hivedb", "tbl", table);
        icebergTable.updateSchema().addColumn("data", (Type)Types.LongType.get()).commit();
    }

    @Test
    public void testListTables() throws TException, IOException {
        List tableIdents = catalog.listTables(TABLE_IDENTIFIER.namespace());
        List expectedIdents = tableIdents.stream().filter(t -> t.namespace().level(0).equals("hivedb") && t.name().equals("tbl")).collect(Collectors.toList());
        Assert.assertEquals((long)1L, (long)expectedIdents.size());
        Assert.assertTrue((boolean)catalog.tableExists(TABLE_IDENTIFIER));
        String hiveTableName = "test_hive_table";
        org.apache.hadoop.hive.metastore.api.Table hiveTable = this.createHiveTable(hiveTableName);
        metastoreClient.createTable(hiveTable);
        catalog.setListAllTables(false);
        List tableIdents1 = catalog.listTables(TABLE_IDENTIFIER.namespace());
        Assert.assertEquals((String)"should only 1 iceberg table .", (long)1L, (long)tableIdents1.size());
        catalog.setListAllTables(true);
        List tableIdents2 = catalog.listTables(TABLE_IDENTIFIER.namespace());
        Assert.assertEquals((String)"should be 2 tables in namespace .", (long)2L, (long)tableIdents2.size());
        Assert.assertTrue((boolean)catalog.tableExists(TABLE_IDENTIFIER));
        metastoreClient.dropTable("hivedb", hiveTableName);
    }

    private org.apache.hadoop.hive.metastore.api.Table createHiveTable(String hiveTableName) throws IOException {
        HashMap parameters = Maps.newHashMap();
        parameters.put("serialization.class", "org.apache.hadoop.hive.serde2.thrift.test.IntString");
        parameters.put("serialization.format", "org.apache.thrift.protocol.TBinaryProtocol");
        SerDeInfo serDeInfo = new SerDeInfo(null, "org.apache.hadoop.hive.serde2.thrift.ThriftDeserializer", (Map)parameters);
        StorageDescriptor sd = new StorageDescriptor((List)Lists.newArrayList(), this.tempFolder.newFolder().getAbsolutePath(), "org.apache.hadoop.mapred.TextInputFormat", "org.apache.hadoop.mapred.TextOutputFormat", false, -1, serDeInfo, (List)Lists.newArrayList(), (List)Lists.newArrayList(), (Map)Maps.newHashMap());
        org.apache.hadoop.hive.metastore.api.Table hiveTable = new org.apache.hadoop.hive.metastore.api.Table(hiveTableName, "hivedb", "test_owner", 0, 0, 0, sd, (List)Lists.newArrayList(), (Map)Maps.newHashMap(), "viewOriginalText", "viewExpandedText", TableType.EXTERNAL_TABLE.name());
        return hiveTable;
    }

    @Test
    public void testNonDefaultDatabaseLocation() throws IOException, TException {
        Namespace namespace = Namespace.of((String[])new String[]{NON_DEFAULT_DATABASE});
        File nonDefaultLocation = java.nio.file.Files.createTempDirectory(NON_DEFAULT_DATABASE, PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwxrwxrwx"))).toFile();
        catalog.createNamespace(namespace, Collections.singletonMap("location", nonDefaultLocation.getPath()));
        Map namespaceMeta = catalog.loadNamespaceMetadata(namespace);
        Assert.assertEquals(namespaceMeta.get("location"), (Object)("file:" + nonDefaultLocation.getPath()));
        TableIdentifier tableIdentifier = TableIdentifier.of((Namespace)namespace, (String)"tbl");
        catalog.createTable(tableIdentifier, schema);
        Table table = catalog.loadTable(tableIdentifier);
        Assert.assertEquals((Object)((String)namespaceMeta.get("location") + "/" + "tbl"), (Object)table.location());
        metastoreClient.dropDatabase(NON_DEFAULT_DATABASE, true, true, true);
    }

    @Test
    public void testRegisterTable() throws TException {
        org.apache.hadoop.hive.metastore.api.Table originalTable = metastoreClient.getTable("hivedb", "tbl");
        Map originalParams = originalTable.getParameters();
        Assert.assertNotNull((Object)originalParams);
        Assert.assertTrue((boolean)"iceberg".equalsIgnoreCase((String)originalParams.get("table_type")));
        Assert.assertTrue((boolean)"EXTERNAL_TABLE".equalsIgnoreCase(originalTable.getTableType()));
        catalog.dropTable(TABLE_IDENTIFIER, false);
        Assert.assertFalse((boolean)catalog.tableExists(TABLE_IDENTIFIER));
        List<String> metadataVersionFiles = HiveTableTest.metadataVersionFiles("tbl");
        Assert.assertEquals((long)1L, (long)metadataVersionFiles.size());
        catalog.registerTable(TABLE_IDENTIFIER, "file:" + metadataVersionFiles.get(0));
        org.apache.hadoop.hive.metastore.api.Table newTable = metastoreClient.getTable("hivedb", "tbl");
        Map newTableParameters = newTable.getParameters();
        Assert.assertNull(newTableParameters.get("previous_metadata_location"));
        Assert.assertEquals(originalParams.get("table_type"), newTableParameters.get("table_type"));
        Assert.assertEquals(originalParams.get("metadata_location"), newTableParameters.get("metadata_location"));
        Assert.assertEquals((Object)originalTable.getSd(), (Object)newTable.getSd());
    }

    @Test
    public void testRegisterHadoopTableToHiveCatalog() throws IOException, TException {
        String tableLocation = this.tempFolder.newFolder().toString();
        HadoopCatalog hadoopCatalog = new HadoopCatalog(new Configuration(), tableLocation);
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{"hivedb", "table1"});
        Table table = hadoopCatalog.createTable(identifier, schema, PartitionSpec.unpartitioned(), (Map)Maps.newHashMap());
        String file1Location = this.appendData(table, "file1");
        ArrayList tasks = Lists.newArrayList((Iterable)table.newScan().planFiles());
        Assert.assertEquals((String)"Should scan 1 file", (long)1L, (long)tasks.size());
        Assert.assertEquals((Object)((DataFile)((FileScanTask)tasks.get(0)).file()).path(), (Object)file1Location);
        List metadataFiles = Arrays.stream(new File(table.location() + "/metadata").listFiles()).map(File::getAbsolutePath).filter(f -> f.endsWith(TableMetadataParser.getFileExtension((TableMetadataParser.Codec)TableMetadataParser.Codec.NONE))).collect(Collectors.toList());
        Assert.assertEquals((long)2L, (long)metadataFiles.size());
        AssertHelpers.assertThrows((String)"Hive metastore should not have this table", NoSuchObjectException.class, (String)"table not found", () -> metastoreClient.getTable("hivedb", "table1"));
        AssertHelpers.assertThrows((String)"Hive catalog should fail to load the table", NoSuchTableException.class, (String)"Table does not exist:", () -> catalog.loadTable(identifier));
        String latestMetadataFile = ((BaseTable)table).operations().current().metadataFileLocation();
        catalog.registerTable(identifier, "file:" + latestMetadataFile);
        Assert.assertNotNull((Object)metastoreClient.getTable("hivedb", "table1"));
        table = catalog.loadTable(identifier);
        Assert.assertNotNull((Object)table);
        String file2Location = this.appendData(table, "file2");
        tasks = Lists.newArrayList((Iterable)table.newScan().planFiles());
        Assert.assertEquals((String)"Should scan 2 files", (long)2L, (long)tasks.size());
        Set files = tasks.stream().map(task -> ((DataFile)task.file()).path().toString()).collect(Collectors.toSet());
        Assert.assertTrue((files.contains(file1Location) && files.contains(file2Location) ? 1 : 0) != 0);
    }

    private String appendData(Table table, String fileName) throws IOException {
        GenericRecordBuilder recordBuilder = new GenericRecordBuilder(AvroSchemaUtil.convert((Schema)schema, (String)"test"));
        ArrayList records = Lists.newArrayList((Object[])new GenericData.Record[]{recordBuilder.set("id", (Object)1L).build(), recordBuilder.set("id", (Object)2L).build(), recordBuilder.set("id", (Object)3L).build()});
        String fileLocation = table.location().replace("file:", "") + "/data/" + fileName + ".avro";
        try (FileAppender writer = Avro.write((OutputFile)Files.localOutput((String)fileLocation)).schema(schema).named("test").build();){
            for (GenericData.Record rec : records) {
                writer.add((Object)rec);
            }
        }
        DataFile file = DataFiles.builder((PartitionSpec)table.spec()).withRecordCount(3L).withPath(fileLocation).withFileSizeInBytes(Files.localInput((String)fileLocation).getLength()).build();
        table.newAppend().appendFile(file).commit();
        return fileLocation;
    }

    @Test
    public void testRegisterExistingTable() throws TException {
        org.apache.hadoop.hive.metastore.api.Table originalTable = metastoreClient.getTable("hivedb", "tbl");
        Map originalParams = originalTable.getParameters();
        Assert.assertNotNull((Object)originalParams);
        Assert.assertTrue((boolean)"iceberg".equalsIgnoreCase((String)originalParams.get("table_type")));
        Assert.assertTrue((boolean)"EXTERNAL_TABLE".equalsIgnoreCase(originalTable.getTableType()));
        List<String> metadataVersionFiles = HiveTableTest.metadataVersionFiles("tbl");
        Assert.assertEquals((long)1L, (long)metadataVersionFiles.size());
        AssertHelpers.assertThrows((String)"Should complain that the table already exists", AlreadyExistsException.class, (String)"Table already exists", () -> catalog.registerTable(TABLE_IDENTIFIER, "file:" + (String)metadataVersionFiles.get(0)));
    }

    @Test
    public void testEngineHiveEnabledDefault() throws TException {
        catalog.dropTable(TABLE_IDENTIFIER);
        catalog.getConf().unset("iceberg.engine.hive.enabled");
        catalog.createTable(TABLE_IDENTIFIER, schema, PartitionSpec.unpartitioned());
        org.apache.hadoop.hive.metastore.api.Table hmsTable = metastoreClient.getTable("hivedb", "tbl");
        this.assertHiveEnabled(hmsTable, false);
    }

    @Test
    public void testEngineHiveEnabledConfig() throws TException {
        catalog.dropTable(TABLE_IDENTIFIER);
        catalog.getConf().set("iceberg.engine.hive.enabled", "true");
        catalog.createTable(TABLE_IDENTIFIER, schema, PartitionSpec.unpartitioned());
        org.apache.hadoop.hive.metastore.api.Table hmsTable = metastoreClient.getTable("hivedb", "tbl");
        this.assertHiveEnabled(hmsTable, true);
        catalog.dropTable(TABLE_IDENTIFIER);
        catalog.getConf().set("iceberg.engine.hive.enabled", "false");
        catalog.createTable(TABLE_IDENTIFIER, schema, PartitionSpec.unpartitioned());
        hmsTable = metastoreClient.getTable("hivedb", "tbl");
        this.assertHiveEnabled(hmsTable, false);
    }

    @Test
    public void testEngineHiveEnabledTableProperty() throws TException {
        catalog.dropTable(TABLE_IDENTIFIER);
        HashMap tableProperties = Maps.newHashMap();
        tableProperties.put("engine.hive.enabled", "true");
        catalog.getConf().set("iceberg.engine.hive.enabled", "false");
        catalog.createTable(TABLE_IDENTIFIER, schema, PartitionSpec.unpartitioned(), (Map)tableProperties);
        org.apache.hadoop.hive.metastore.api.Table hmsTable = metastoreClient.getTable("hivedb", "tbl");
        this.assertHiveEnabled(hmsTable, true);
        catalog.dropTable(TABLE_IDENTIFIER);
        tableProperties.put("engine.hive.enabled", "false");
        catalog.getConf().set("iceberg.engine.hive.enabled", "true");
        catalog.createTable(TABLE_IDENTIFIER, schema, PartitionSpec.unpartitioned(), (Map)tableProperties);
        hmsTable = metastoreClient.getTable("hivedb", "tbl");
        this.assertHiveEnabled(hmsTable, false);
    }

    @Test
    public void testMissingMetadataWontCauseHang() {
        catalog.loadTable(TABLE_IDENTIFIER);
        File realLocation = new File(HiveTableTest.metadataLocation("tbl"));
        File fakeLocation = new File(HiveTableTest.metadataLocation("tbl") + "_dummy");
        Assert.assertTrue((boolean)realLocation.renameTo(fakeLocation));
        AssertHelpers.assertThrows((String)"HiveTableOperations shouldn't hang indefinitely when a missing metadata file is encountered", NotFoundException.class, () -> catalog.loadTable(TABLE_IDENTIFIER));
        Assert.assertTrue((boolean)fakeLocation.renameTo(realLocation));
    }

    private void assertHiveEnabled(org.apache.hadoop.hive.metastore.api.Table hmsTable, boolean expected) {
        if (expected) {
            Assert.assertEquals((Object)"org.apache.iceberg.mr.hive.HiveIcebergStorageHandler", hmsTable.getParameters().get("storage_handler"));
            Assert.assertEquals((Object)"org.apache.iceberg.mr.hive.HiveIcebergSerDe", (Object)hmsTable.getSd().getSerdeInfo().getSerializationLib());
            Assert.assertEquals((Object)"org.apache.iceberg.mr.hive.HiveIcebergInputFormat", (Object)hmsTable.getSd().getInputFormat());
            Assert.assertEquals((Object)"org.apache.iceberg.mr.hive.HiveIcebergOutputFormat", (Object)hmsTable.getSd().getOutputFormat());
        } else {
            Assert.assertNull(hmsTable.getParameters().get("storage_handler"));
            Assert.assertEquals((Object)"org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe", (Object)hmsTable.getSd().getSerdeInfo().getSerializationLib());
            Assert.assertEquals((Object)"org.apache.hadoop.mapred.FileInputFormat", (Object)hmsTable.getSd().getInputFormat());
            Assert.assertEquals((Object)"org.apache.hadoop.mapred.FileOutputFormat", (Object)hmsTable.getSd().getOutputFormat());
        }
    }
}

