/*
 * Copyright 2012 The Netty Project
 *
 * The Netty Project licenses this file to you under the Apache License,
 * version 2.0 (the "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */
package org.apache.hbase.thirdparty.org.apache.hbase.thirdparty.io.netty.channel.udt.nio;

import com.barchart.udt.TypeUDT;
import com.barchart.udt.nio.ServerSocketChannelUDT;
import com.barchart.udt.nio.SocketChannelUDT;
import org.apache.hbase.thirdparty.org.apache.hbase.thirdparty.io.netty.channel.ChannelException;
import org.apache.hbase.thirdparty.org.apache.hbase.thirdparty.io.netty.channel.ChannelMetadata;
import org.apache.hbase.thirdparty.org.apache.hbase.thirdparty.io.netty.channel.ChannelOutboundBuffer;
import org.apache.hbase.thirdparty.org.apache.hbase.thirdparty.io.netty.util.internal.SocketUtils;
import org.apache.hbase.thirdparty.org.apache.hbase.thirdparty.io.netty.channel.nio.AbstractNioMessageChannel;
import org.apache.hbase.thirdparty.org.apache.hbase.thirdparty.io.netty.channel.udt.DefaultUdtServerChannelConfig;
import org.apache.hbase.thirdparty.org.apache.hbase.thirdparty.io.netty.channel.udt.UdtChannel;
import org.apache.hbase.thirdparty.org.apache.hbase.thirdparty.io.netty.channel.udt.UdtServerChannel;
import org.apache.hbase.thirdparty.org.apache.hbase.thirdparty.io.netty.channel.udt.UdtServerChannelConfig;
import org.apache.hbase.thirdparty.org.apache.hbase.thirdparty.io.netty.util.internal.logging.InternalLogger;
import org.apache.hbase.thirdparty.org.apache.hbase.thirdparty.io.netty.util.internal.logging.InternalLoggerFactory;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;

import static java.nio.channels.SelectionKey.*;

/**
 * Common base for Netty Byte/Message UDT Stream/Datagram acceptors.
 *
 * @deprecated The UDT transport is no longer maintained and will be removed.
 */
@Deprecated
public abstract class NioUdtAcceptorChannel extends AbstractNioMessageChannel implements UdtServerChannel {

    protected static final InternalLogger logger =
            InternalLoggerFactory.getInstance(NioUdtAcceptorChannel.class);

    private static final ChannelMetadata METADATA = new ChannelMetadata(false, 16);

    private final UdtServerChannelConfig config;

    protected NioUdtAcceptorChannel(final ServerSocketChannelUDT channelUDT) {
        super(null, channelUDT, OP_ACCEPT);
        try {
            channelUDT.configureBlocking(false);
            config = new DefaultUdtServerChannelConfig(this, channelUDT, true);
        } catch (final Exception e) {
            try {
                channelUDT.close();
            } catch (final Exception e2) {
                if (logger.isWarnEnabled()) {
                    logger.warn("Failed to close channel.", e2);
                }
            }
            throw new ChannelException("Failed to configure channel.", e);
        }
    }

    protected NioUdtAcceptorChannel(final TypeUDT type) {
        this(NioUdtProvider.newAcceptorChannelUDT(type));
    }

    @Override
    public UdtServerChannelConfig config() {
        return config;
    }

    @Override
    protected void doBind(final SocketAddress localAddress) throws Exception {
        javaChannel().socket().bind(localAddress, config.getBacklog());
    }

    @Override
    protected void doClose() throws Exception {
        javaChannel().close();
    }

    @Override
    protected boolean doConnect(final SocketAddress remoteAddress,
            final SocketAddress localAddress) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void doDisconnect() throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void doFinishConnect() throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean doWriteMessage(Object msg, ChannelOutboundBuffer in) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    protected final Object filterOutboundMessage(Object msg) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isActive() {
        return javaChannel().socket().isBound();
    }

    @Override
    protected ServerSocketChannelUDT javaChannel() {
        return (ServerSocketChannelUDT) super.javaChannel();
    }

    @Override
    protected SocketAddress localAddress0() {
        return SocketUtils.localSocketAddress(javaChannel().socket());
    }

    @Override
    public InetSocketAddress localAddress() {
        return (InetSocketAddress) super.localAddress();
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return null;
    }

    @Override
    protected SocketAddress remoteAddress0() {
        return null;
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    @Override
    protected int doReadMessages(List<Object> buf) throws Exception {
        final SocketChannelUDT channelUDT = (SocketChannelUDT) SocketUtils.accept(javaChannel());
        if (channelUDT == null) {
            return 0;
        } else {
            buf.add(newConnectorChannel(channelUDT));
            return 1;
        }
    }

    protected abstract UdtChannel newConnectorChannel(SocketChannelUDT channelUDT);
}
