/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TestCombineTextInputFormat;
import org.apache.hadoop.mapred.lib.CombineFileSplit;
import org.apache.hadoop.mapred.lib.CombineTextInputFormat;
import org.apache.hadoop.util.ReflectionUtils;
import org.junit.Assert;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestCombineTextInputFormat {
    private static final Log LOG = LogFactory.getLog(TestCombineTextInputFormat.class);
    private static JobConf defaultConf = new JobConf();
    private static FileSystem localFs = null;
    private static Path workDir;
    private static final Reporter voidReporter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testFormat() throws Exception {
        JobConf job = new JobConf((Configuration)defaultConf);
        Random random = new Random();
        long seed = random.nextLong();
        LOG.info((Object)("seed = " + seed));
        random.setSeed(seed);
        localFs.delete(workDir, true);
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{workDir});
        int length = 10000;
        int numFiles = 10;
        TestCombineTextInputFormat.createFiles((int)10000, (int)10, (Random)random);
        CombineTextInputFormat format = new CombineTextInputFormat();
        LongWritable key = new LongWritable();
        Text value = new Text();
        for (int i = 0; i < 3; ++i) {
            int numSplits = random.nextInt(500) + 1;
            LOG.info((Object)("splitting: requesting = " + numSplits));
            InputSplit[] splits = format.getSplits(job, numSplits);
            LOG.info((Object)("splitting: got =        " + splits.length));
            Assert.assertEquals((String)"We got more than one splits!", (long)1L, (long)splits.length);
            InputSplit split = splits[0];
            Assert.assertEquals((String)"It should be CombineFileSplit", CombineFileSplit.class, split.getClass());
            BitSet bits = new BitSet(10000);
            LOG.debug((Object)("split= " + split));
            RecordReader reader = format.getRecordReader(split, job, voidReporter);
            try {
                int count = 0;
                while (reader.next((Object)key, (Object)value)) {
                    int v = Integer.parseInt(value.toString());
                    LOG.debug((Object)("read " + v));
                    if (bits.get(v)) {
                        LOG.warn((Object)("conflict with " + v + " at position " + reader.getPos()));
                    }
                    Assert.assertFalse((String)"Key in multiple partitions.", (boolean)bits.get(v));
                    bits.set(v);
                    ++count;
                }
                LOG.info((Object)("splits=" + split + " count=" + count));
            }
            finally {
                reader.close();
            }
            Assert.assertEquals((String)"Some keys in no partition.", (long)10000L, (long)bits.cardinality());
        }
    }

    private static Range[] createRanges(int length, int numFiles, Random random) {
        Range[] ranges = new Range[numFiles];
        for (int i = 0; i < numFiles; ++i) {
            int start = i == 0 ? 0 : Range.access$000((Range)ranges[i - 1]);
            int end = i == numFiles - 1 ? length : length / numFiles * (2 * i + 1) / 2 + random.nextInt(length / numFiles) + 1;
            ranges[i] = new Range(start, end);
        }
        return ranges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createFiles(int length, int numFiles, Random random) throws IOException {
        Range[] ranges = TestCombineTextInputFormat.createRanges((int)length, (int)numFiles, (Random)random);
        for (int i = 0; i < numFiles; ++i) {
            Path file = new Path(workDir, "test_" + i + ".txt");
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)localFs.create(file));
            Range range = ranges[i];
            try {
                for (int j = Range.access$100((Range)range); j < Range.access$000((Range)range); ++j) {
                    writer.write(Integer.toString(j));
                    writer.write("\n");
                }
                continue;
            }
            finally {
                ((Writer)writer).close();
            }
        }
    }

    private static void writeFile(FileSystem fs, Path name, CompressionCodec codec, String contents) throws IOException {
        Object stm = codec == null ? fs.create(name) : codec.createOutputStream((OutputStream)fs.create(name));
        stm.write(contents.getBytes());
        stm.close();
    }

    private static List<Text> readSplit(InputFormat<LongWritable, Text> format, InputSplit split, JobConf job) throws IOException {
        ArrayList<Text> result = new ArrayList<Text>();
        RecordReader reader = format.getRecordReader(split, job, voidReporter);
        LongWritable key = (LongWritable)reader.createKey();
        Text value = (Text)reader.createValue();
        while (reader.next((Object)key, (Object)value)) {
            result.add(value);
            value = (Text)reader.createValue();
        }
        reader.close();
        return result;
    }

    @Test(timeout=10000L)
    public void testGzip() throws IOException {
        JobConf job = new JobConf((Configuration)defaultConf);
        GzipCodec gzip = new GzipCodec();
        ReflectionUtils.setConf((Object)gzip, (Configuration)job);
        localFs.delete(workDir, true);
        TestCombineTextInputFormat.writeFile((FileSystem)localFs, (Path)new Path(workDir, "part1.txt.gz"), (CompressionCodec)gzip, (String)"the quick\nbrown\nfox jumped\nover\n the lazy\n dog\n");
        TestCombineTextInputFormat.writeFile((FileSystem)localFs, (Path)new Path(workDir, "part2.txt.gz"), (CompressionCodec)gzip, (String)"this is a test\nof gzip\n");
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{workDir});
        CombineTextInputFormat format = new CombineTextInputFormat();
        InputSplit[] splits = format.getSplits(job, 100);
        Assert.assertEquals((String)"compressed splits == 1", (long)1L, (long)splits.length);
        List results = TestCombineTextInputFormat.readSplit((InputFormat)format, (InputSplit)splits[0], (JobConf)job);
        Assert.assertEquals((String)"splits[0] length", (long)8L, (long)results.size());
        String[] firstList = new String[]{"the quick", "brown", "fox jumped", "over", " the lazy", " dog"};
        String[] secondList = new String[]{"this is a test", "of gzip"};
        String first = ((Text)results.get(0)).toString();
        if (first.equals(firstList[0])) {
            TestCombineTextInputFormat.testResults((List)results, (String[])firstList, (String[])secondList);
        } else if (first.equals(secondList[0])) {
            TestCombineTextInputFormat.testResults((List)results, (String[])secondList, (String[])firstList);
        } else {
            Assert.fail((String)"unexpected first token!");
        }
    }

    private static void testResults(List<Text> results, String[] first, String[] second) {
        int i;
        for (i = 0; i < first.length; ++i) {
            Assert.assertEquals((String)("splits[0][" + i + "]"), (Object)first[i], (Object)results.get(i).toString());
        }
        for (i = 0; i < second.length; ++i) {
            int j = i + first.length;
            Assert.assertEquals((String)("splits[0][" + j + "]"), (Object)second[i], (Object)results.get(j).toString());
        }
    }

    static {
        try {
            defaultConf.set("fs.defaultFS", "file:///");
            localFs = FileSystem.getLocal((Configuration)defaultConf);
        }
        catch (IOException e) {
            throw new RuntimeException("init failure", e);
        }
        workDir = new Path(new Path(System.getProperty("test.build.data", "/tmp")), "TestCombineTextInputFormat").makeQualified(localFs);
        voidReporter = Reporter.NULL;
    }
}

