/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.window;

import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.utils.JoinedRowData;
import org.apache.flink.table.runtime.generated.GeneratedNamespaceAggsHandleFunction;
import org.apache.flink.table.runtime.generated.GeneratedRecordEqualiser;
import org.apache.flink.table.runtime.generated.NamespaceAggsHandleFunction;
import org.apache.flink.table.runtime.generated.RecordEqualiser;
import org.apache.flink.table.runtime.operators.window.Window;
import org.apache.flink.table.runtime.operators.window.WindowOperator;
import org.apache.flink.table.runtime.operators.window.assigners.WindowAssigner;
import org.apache.flink.table.runtime.operators.window.triggers.Trigger;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Preconditions;

public class AggregateWindowOperator<K, W extends Window>
extends WindowOperator<K, W> {
    private static final long serialVersionUID = 1L;
    private NamespaceAggsHandleFunction<W> aggWindowAggregator;
    private GeneratedNamespaceAggsHandleFunction<W> generatedAggWindowAggregator;
    private transient JoinedRowData reuseOutput;
    protected RecordEqualiser equaliser;
    private GeneratedRecordEqualiser generatedEqualiser;

    AggregateWindowOperator(NamespaceAggsHandleFunction<W> windowAggregator, RecordEqualiser equaliser, WindowAssigner<W> windowAssigner, Trigger<W> trigger, TypeSerializer<W> windowSerializer, LogicalType[] inputFieldTypes, LogicalType[] accumulatorTypes, LogicalType[] aggResultTypes, LogicalType[] windowPropertyTypes, int rowtimeIndex, boolean produceUpdates, long allowedLateness) {
        super(windowAggregator, windowAssigner, trigger, windowSerializer, inputFieldTypes, accumulatorTypes, aggResultTypes, windowPropertyTypes, rowtimeIndex, produceUpdates, allowedLateness);
        this.aggWindowAggregator = windowAggregator;
        this.equaliser = (RecordEqualiser)Preconditions.checkNotNull((Object)equaliser);
    }

    AggregateWindowOperator(GeneratedNamespaceAggsHandleFunction<W> generatedAggWindowAggregator, GeneratedRecordEqualiser generatedEqualiser, WindowAssigner<W> windowAssigner, Trigger<W> trigger, TypeSerializer<W> windowSerializer, LogicalType[] inputFieldTypes, LogicalType[] accumulatorTypes, LogicalType[] aggResultTypes, LogicalType[] windowPropertyTypes, int rowtimeIndex, boolean sendRetraction, long allowedLateness) {
        super(windowAssigner, trigger, windowSerializer, inputFieldTypes, accumulatorTypes, aggResultTypes, windowPropertyTypes, rowtimeIndex, sendRetraction, allowedLateness);
        this.generatedAggWindowAggregator = generatedAggWindowAggregator;
        this.generatedEqualiser = (GeneratedRecordEqualiser)Preconditions.checkNotNull((Object)generatedEqualiser);
    }

    @Override
    public void open() throws Exception {
        super.open();
        this.reuseOutput = new JoinedRowData();
    }

    @Override
    protected void compileGeneratedCode() {
        if (this.generatedAggWindowAggregator != null) {
            this.aggWindowAggregator = (NamespaceAggsHandleFunction)this.generatedAggWindowAggregator.newInstance(this.getRuntimeContext().getUserCodeClassLoader());
            this.windowAggregator = this.aggWindowAggregator;
        }
        if (this.generatedEqualiser != null) {
            this.equaliser = (RecordEqualiser)this.generatedEqualiser.newInstance(this.getRuntimeContext().getUserCodeClassLoader());
        }
    }

    @Override
    protected void emitWindowResult(W window) throws Exception {
        this.windowFunction.prepareAggregateAccumulatorForEmit(window);
        RowData aggResult = this.aggWindowAggregator.getValue(window);
        if (this.produceUpdates) {
            this.previousState.setCurrentNamespace(window);
            RowData previousAggResult = (RowData)this.previousState.value();
            if (previousAggResult != null) {
                if (!this.equaliser.equals(aggResult, previousAggResult)) {
                    this.collect(RowKind.UPDATE_BEFORE, (RowData)this.getCurrentKey(), previousAggResult);
                    this.collect(RowKind.UPDATE_AFTER, (RowData)this.getCurrentKey(), aggResult);
                    this.previousState.update((Object)aggResult);
                }
            } else {
                this.collect(RowKind.INSERT, (RowData)this.getCurrentKey(), aggResult);
                this.previousState.update((Object)aggResult);
            }
        } else {
            this.collect(RowKind.INSERT, (RowData)this.getCurrentKey(), aggResult);
        }
    }

    private void collect(RowKind rowKind, RowData key, RowData aggResult) {
        this.reuseOutput.replace((RowData)this.getCurrentKey(), aggResult);
        this.reuseOutput.setRowKind(rowKind);
        this.collector.collect((Object)this.reuseOutput);
    }
}

