/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.sink;

import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.operators.AbstractUdfStreamOperator;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.LatencyMarker;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.runtime.operators.sink.SinkNotNullEnforcer;

public class SinkOperator
extends AbstractUdfStreamOperator<Object, SinkFunction<RowData>>
implements OneInputStreamOperator<RowData, Object> {
    private static final long serialVersionUID = 1L;
    private final int rowtimeFieldIndex;
    private final SinkNotNullEnforcer enforcer;
    private transient SimpleContext sinkContext;
    private long currentWatermark = Long.MIN_VALUE;

    public SinkOperator(SinkFunction<RowData> sinkFunction, int rowtimeFieldIndex, SinkNotNullEnforcer enforcer) {
        super(sinkFunction);
        this.rowtimeFieldIndex = rowtimeFieldIndex;
        this.enforcer = enforcer;
        this.chainingStrategy = ChainingStrategy.ALWAYS;
    }

    public void open() throws Exception {
        super.open();
        this.sinkContext = new SimpleContext(this.getProcessingTimeService());
    }

    public void processElement(StreamRecord<RowData> element) throws Exception {
        this.sinkContext.element = element;
        RowData row = (RowData)element.getValue();
        if (this.enforcer.filter(row)) {
            ((SinkFunction)this.userFunction).invoke((Object)row, (SinkFunction.Context)this.sinkContext);
        }
    }

    protected void reportOrForwardLatencyMarker(LatencyMarker marker) {
        this.latencyStats.reportLatency(marker);
    }

    public void processWatermark(Watermark mark) throws Exception {
        super.processWatermark(mark);
        this.currentWatermark = mark.getTimestamp();
    }

    private class SimpleContext
    implements SinkFunction.Context {
        private StreamRecord<RowData> element;
        private final ProcessingTimeService processingTimeService;

        public SimpleContext(ProcessingTimeService processingTimeService) {
            this.processingTimeService = processingTimeService;
        }

        public long currentProcessingTime() {
            return this.processingTimeService.getCurrentProcessingTime();
        }

        public long currentWatermark() {
            return SinkOperator.this.currentWatermark;
        }

        public Long timestamp() {
            if (SinkOperator.this.rowtimeFieldIndex >= 0) {
                TimestampData timestamp = ((RowData)this.element.getValue()).getTimestamp(SinkOperator.this.rowtimeFieldIndex, 3);
                if (timestamp != null) {
                    return timestamp.getMillisecond();
                }
                return null;
            }
            return null;
        }
    }
}

