/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.filesystem.stream;

import java.io.IOException;
import java.util.List;
import org.apache.flink.api.common.state.OperatorStateStore;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;
import org.apache.flink.table.filesystem.FileSystemOptions;
import org.apache.flink.table.filesystem.stream.PartitionTimeCommitTrigger;
import org.apache.flink.table.filesystem.stream.ProcTimeCommitTrigger;

public interface PartitionCommitTrigger {
    public static final String PARTITION_TIME = "partition-time";
    public static final String PROCESS_TIME = "process-time";

    public void addPartition(String var1);

    public List<String> committablePartitions(long var1) throws IOException;

    public List<String> endInput();

    public void snapshotState(long var1, long var3) throws Exception;

    public static PartitionCommitTrigger create(boolean isRestored, OperatorStateStore stateStore, Configuration conf, ClassLoader cl, List<String> partitionKeys, ProcessingTimeService procTimeService) throws Exception {
        String trigger;
        switch (trigger = (String)conf.get(FileSystemOptions.SINK_PARTITION_COMMIT_TRIGGER)) {
            case "partition-time": {
                return new PartitionTimeCommitTrigger(isRestored, stateStore, conf, cl, partitionKeys);
            }
            case "process-time": {
                return new ProcTimeCommitTrigger(isRestored, stateStore, conf, procTimeService);
            }
        }
        throw new UnsupportedOperationException("Unsupported partition commit trigger: " + trigger);
    }
}

