/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.typeutils;

import java.util.Objects;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.dataformat.SqlTimestamp;
import org.apache.flink.table.runtime.typeutils.SqlTimestampSerializer;

public class SqlTimestampTypeInfo
extends TypeInformation<SqlTimestamp> {
    private static final long serialVersionUID = 1L;
    private final int precision;

    public SqlTimestampTypeInfo(int precision) {
        this.precision = precision;
    }

    public boolean isBasicType() {
        return true;
    }

    public boolean isTupleType() {
        return false;
    }

    public int getArity() {
        return 1;
    }

    public int getTotalFields() {
        return 1;
    }

    public Class<SqlTimestamp> getTypeClass() {
        return SqlTimestamp.class;
    }

    public boolean isKeyType() {
        return true;
    }

    public TypeSerializer<SqlTimestamp> createSerializer(ExecutionConfig config) {
        return new SqlTimestampSerializer(this.precision);
    }

    public String toString() {
        return String.format("Timestamp(%d)", this.precision);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SqlTimestampTypeInfo)) {
            return false;
        }
        SqlTimestampTypeInfo that = (SqlTimestampTypeInfo)((Object)obj);
        return this.precision == that.precision;
    }

    public int hashCode() {
        return Objects.hash(((Object)((Object)this)).getClass().getCanonicalName(), this.precision);
    }

    public boolean canEqual(Object obj) {
        return obj instanceof SqlTimestampTypeInfo;
    }

    public int getPrecision() {
        return this.precision;
    }
}

