/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.typeutils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerUtil;
import org.apache.flink.api.common.typeutils.NestedSerializersSnapshotDelegate;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.java.typeutils.runtime.DataInputViewStream;
import org.apache.flink.api.java.typeutils.runtime.DataOutputViewStream;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.memory.AbstractPagedInputView;
import org.apache.flink.runtime.memory.AbstractPagedOutputView;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.BinaryRow;
import org.apache.flink.table.dataformat.BinaryRowWriter;
import org.apache.flink.table.dataformat.BinaryWriter;
import org.apache.flink.table.dataformat.GenericRow;
import org.apache.flink.table.dataformat.TypeGetterSetters;
import org.apache.flink.table.runtime.types.InternalSerializers;
import org.apache.flink.table.runtime.typeutils.AbstractRowSerializer;
import org.apache.flink.table.runtime.typeutils.BinaryRowSerializer;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.InstantiationUtil;

public class BaseRowSerializer
extends AbstractRowSerializer<BaseRow> {
    private BinaryRowSerializer binarySerializer;
    private final LogicalType[] types;
    private final TypeSerializer[] fieldSerializers;
    private transient BinaryRow reuseRow;
    private transient BinaryRowWriter reuseWriter;

    public BaseRowSerializer(ExecutionConfig config, RowType rowType) {
        this(rowType.getChildren().toArray(new LogicalType[0]), (TypeSerializer[])rowType.getChildren().stream().map(type -> InternalSerializers.create(type, config)).toArray(TypeSerializer[]::new));
    }

    public BaseRowSerializer(ExecutionConfig config, LogicalType ... types) {
        this(types, (TypeSerializer[])Arrays.stream(types).map(type -> InternalSerializers.create(type, config)).toArray(TypeSerializer[]::new));
    }

    public BaseRowSerializer(LogicalType[] types, TypeSerializer[] fieldSerializers) {
        this.types = types;
        this.fieldSerializers = fieldSerializers;
        this.binarySerializer = new BinaryRowSerializer(types.length);
    }

    public TypeSerializer<BaseRow> duplicate() {
        TypeSerializer[] duplicateFieldSerializers = new TypeSerializer[this.fieldSerializers.length];
        for (int i = 0; i < this.fieldSerializers.length; ++i) {
            duplicateFieldSerializers[i] = this.fieldSerializers[i].duplicate();
        }
        return new BaseRowSerializer(this.types, duplicateFieldSerializers);
    }

    public BaseRow createInstance() {
        return new BinaryRow(this.types.length);
    }

    public void serialize(BaseRow row, DataOutputView target) throws IOException {
        this.binarySerializer.serialize(this.toBinaryRow(row), target);
    }

    public BaseRow deserialize(DataInputView source) throws IOException {
        return this.binarySerializer.deserialize(source);
    }

    public BaseRow deserialize(BaseRow reuse, DataInputView source) throws IOException {
        if (reuse instanceof BinaryRow) {
            return this.binarySerializer.deserialize((BinaryRow)reuse, source);
        }
        return this.binarySerializer.deserialize(source);
    }

    public BaseRow copy(BaseRow from) {
        if (from.getArity() != this.types.length) {
            throw new IllegalArgumentException("Row arity: " + from.getArity() + ", but serializer arity: " + this.types.length);
        }
        if (from instanceof BinaryRow) {
            return ((BinaryRow)from).copy();
        }
        return this.copyBaseRow(from, new GenericRow(from.getArity()));
    }

    public BaseRow copy(BaseRow from, BaseRow reuse) {
        if (from.getArity() != this.types.length || reuse.getArity() != this.types.length) {
            throw new IllegalArgumentException("Row arity: " + from.getArity() + ", Ruese Row arity: " + reuse.getArity() + ", but serializer arity: " + this.types.length);
        }
        if (from instanceof BinaryRow) {
            return reuse instanceof BinaryRow ? ((BinaryRow)from).copy((BinaryRow)reuse) : ((BinaryRow)from).copy();
        }
        return this.copyBaseRow(from, reuse);
    }

    private BaseRow copyBaseRow(BaseRow from, BaseRow reuse) {
        GenericRow ret = reuse instanceof GenericRow ? (GenericRow)reuse : new GenericRow(from.getArity());
        ret.setHeader(from.getHeader());
        for (int i = 0; i < from.getArity(); ++i) {
            if (!from.isNullAt(i)) {
                ret.setField(i, this.fieldSerializers[i].copy(TypeGetterSetters.get(from, i, this.types[i])));
                continue;
            }
            ret.setNullAt(i);
        }
        return ret;
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.binarySerializer.copy(source, target);
    }

    @Override
    public int getArity() {
        return this.types.length;
    }

    @Override
    public BinaryRow toBinaryRow(BaseRow row) {
        if (row instanceof BinaryRow) {
            return (BinaryRow)row;
        }
        if (this.reuseRow == null) {
            this.reuseRow = new BinaryRow(this.types.length);
            this.reuseWriter = new BinaryRowWriter(this.reuseRow);
        }
        this.reuseWriter.reset();
        this.reuseWriter.writeHeader(row.getHeader());
        for (int i = 0; i < this.types.length; ++i) {
            if (row.isNullAt(i)) {
                this.reuseWriter.setNullAt(i);
                continue;
            }
            BinaryWriter.write(this.reuseWriter, i, TypeGetterSetters.get(row, i, this.types[i]), this.types[i], this.fieldSerializers[i]);
        }
        this.reuseWriter.complete();
        return this.reuseRow;
    }

    @Override
    public int serializeToPages(BaseRow row, AbstractPagedOutputView target) throws IOException {
        return this.binarySerializer.serializeToPages(this.toBinaryRow(row), target);
    }

    @Override
    public BaseRow deserializeFromPages(AbstractPagedInputView source) throws IOException {
        throw new UnsupportedOperationException("Not support!");
    }

    @Override
    public BaseRow deserializeFromPages(BaseRow reuse, AbstractPagedInputView source) throws IOException {
        throw new UnsupportedOperationException("Not support!");
    }

    @Override
    public BaseRow mapFromPages(AbstractPagedInputView source) throws IOException {
        return this.binarySerializer.mapFromPages(source);
    }

    @Override
    public BaseRow mapFromPages(BaseRow reuse, AbstractPagedInputView source) throws IOException {
        if (reuse instanceof BinaryRow) {
            return this.binarySerializer.mapFromPages((BinaryRow)reuse, source);
        }
        throw new UnsupportedOperationException("Not support!");
    }

    public boolean equals(Object obj) {
        if (obj instanceof BaseRowSerializer) {
            BaseRowSerializer other = (BaseRowSerializer)((Object)obj);
            return Arrays.equals(this.types, other.types);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.types);
    }

    public boolean isImmutableType() {
        return false;
    }

    public int getLength() {
        return -1;
    }

    public TypeSerializerSnapshot<BaseRow> snapshotConfiguration() {
        return new BaseRowSerializerSnapshot(this.types, this.fieldSerializers);
    }

    public static final class BaseRowSerializerSnapshot
    implements TypeSerializerSnapshot<BaseRow> {
        private static final int CURRENT_VERSION = 3;
        private LogicalType[] previousTypes;
        private NestedSerializersSnapshotDelegate nestedSerializersSnapshotDelegate;

        public BaseRowSerializerSnapshot() {
        }

        BaseRowSerializerSnapshot(LogicalType[] types, TypeSerializer[] serializers) {
            this.previousTypes = types;
            this.nestedSerializersSnapshotDelegate = new NestedSerializersSnapshotDelegate(serializers);
        }

        public int getCurrentVersion() {
            return 3;
        }

        public void writeSnapshot(DataOutputView out) throws IOException {
            out.writeInt(this.previousTypes.length);
            DataOutputViewStream stream = new DataOutputViewStream(out);
            for (LogicalType previousType : this.previousTypes) {
                InstantiationUtil.serializeObject((OutputStream)stream, (Object)previousType);
            }
            this.nestedSerializersSnapshotDelegate.writeNestedSerializerSnapshots(out);
        }

        public void readSnapshot(int readVersion, DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
            int length = in.readInt();
            DataInputViewStream stream = new DataInputViewStream(in);
            this.previousTypes = new LogicalType[length];
            for (int i = 0; i < length; ++i) {
                try {
                    this.previousTypes[i] = (LogicalType)InstantiationUtil.deserializeObject((InputStream)stream, (ClassLoader)userCodeClassLoader);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    throw new IOException(e);
                }
            }
            this.nestedSerializersSnapshotDelegate = NestedSerializersSnapshotDelegate.readNestedSerializerSnapshots((DataInputView)in, (ClassLoader)userCodeClassLoader);
        }

        public BaseRowSerializer restoreSerializer() {
            return new BaseRowSerializer(this.previousTypes, this.nestedSerializersSnapshotDelegate.getRestoredNestedSerializers());
        }

        public TypeSerializerSchemaCompatibility<BaseRow> resolveSchemaCompatibility(TypeSerializer<BaseRow> newSerializer) {
            if (!(newSerializer instanceof BaseRowSerializer)) {
                return TypeSerializerSchemaCompatibility.incompatible();
            }
            BaseRowSerializer newRowSerializer = (BaseRowSerializer)newSerializer;
            if (!Arrays.equals(this.previousTypes, newRowSerializer.types)) {
                return TypeSerializerSchemaCompatibility.incompatible();
            }
            CompositeTypeSerializerUtil.IntermediateCompatibilityResult intermediateResult = CompositeTypeSerializerUtil.constructIntermediateCompatibilityResult((TypeSerializer[])newRowSerializer.fieldSerializers, (TypeSerializerSnapshot[])this.nestedSerializersSnapshotDelegate.getNestedSerializerSnapshots());
            if (intermediateResult.isCompatibleWithReconfiguredSerializer()) {
                BaseRowSerializer reconfiguredCompositeSerializer = this.restoreSerializer();
                return TypeSerializerSchemaCompatibility.compatibleWithReconfiguredSerializer((TypeSerializer)reconfiguredCompositeSerializer);
            }
            return intermediateResult.getFinalResult();
        }
    }
}

