/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.over;

import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.JoinedRow;
import org.apache.flink.table.runtime.dataview.PerKeyStateDataViewStore;
import org.apache.flink.table.runtime.functions.KeyedProcessFunctionWithCleanupState;
import org.apache.flink.table.runtime.generated.AggsHandleFunction;
import org.apache.flink.table.runtime.generated.GeneratedAggsHandleFunction;
import org.apache.flink.table.runtime.typeutils.BaseRowTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.Collector;

public class ProcTimeUnboundedPrecedingFunction<K>
extends KeyedProcessFunctionWithCleanupState<K, BaseRow, BaseRow> {
    private static final long serialVersionUID = 1L;
    private final GeneratedAggsHandleFunction genAggsHandler;
    private final LogicalType[] accTypes;
    private transient AggsHandleFunction function;
    private transient ValueState<BaseRow> accState;
    private transient JoinedRow output;

    public ProcTimeUnboundedPrecedingFunction(long minRetentionTime, long maxRetentionTime, GeneratedAggsHandleFunction genAggsHandler, LogicalType[] accTypes) {
        super(minRetentionTime, maxRetentionTime);
        this.genAggsHandler = genAggsHandler;
        this.accTypes = accTypes;
    }

    public void open(Configuration parameters) throws Exception {
        this.function = (AggsHandleFunction)this.genAggsHandler.newInstance(this.getRuntimeContext().getUserCodeClassLoader());
        this.function.open(new PerKeyStateDataViewStore(this.getRuntimeContext()));
        this.output = new JoinedRow();
        BaseRowTypeInfo accTypeInfo = new BaseRowTypeInfo(this.accTypes);
        ValueStateDescriptor stateDescriptor = new ValueStateDescriptor("accState", (TypeInformation)accTypeInfo);
        this.accState = this.getRuntimeContext().getState(stateDescriptor);
        this.initCleanupTimeState("ProcTimeUnboundedOverCleanupTime");
    }

    public void processElement(BaseRow input, KeyedProcessFunction.Context ctx, Collector<BaseRow> out) throws Exception {
        this.registerProcessingCleanupTimer(ctx, ctx.timerService().currentProcessingTime());
        BaseRow accumulators = (BaseRow)this.accState.value();
        if (null == accumulators) {
            accumulators = this.function.createAccumulators();
        }
        this.function.setAccumulators(accumulators);
        this.function.accumulate(input);
        accumulators = this.function.getAccumulators();
        this.accState.update((Object)accumulators);
        BaseRow aggValue = this.function.getValue();
        this.output.replace(input, aggValue);
        out.collect((Object)this.output);
    }

    public void onTimer(long timestamp, KeyedProcessFunction.OnTimerContext ctx, Collector<BaseRow> out) throws Exception {
        if (this.stateCleaningEnabled) {
            this.cleanupState(new State[]{this.accState});
            this.function.cleanup();
        }
    }

    public void close() throws Exception {
        if (null != this.function) {
            this.function.close();
        }
    }
}

