/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.deduplicate;

import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.runtime.context.ExecutionContext;
import org.apache.flink.table.runtime.operators.bundle.MapBundleFunction;
import org.apache.flink.table.runtime.operators.deduplicate.DeduplicateFunctionHelper;
import org.apache.flink.util.Collector;

public class MiniBatchDeduplicateKeepFirstRowFunction
extends MapBundleFunction<BaseRow, BaseRow, BaseRow, BaseRow> {
    private static final long serialVersionUID = -7994602893547654994L;
    private final TypeSerializer<BaseRow> typeSerializer;
    private ValueState<Boolean> state;

    public MiniBatchDeduplicateKeepFirstRowFunction(TypeSerializer<BaseRow> typeSerializer) {
        this.typeSerializer = typeSerializer;
    }

    @Override
    public void open(ExecutionContext ctx) throws Exception {
        super.open(ctx);
        ValueStateDescriptor stateDesc = new ValueStateDescriptor("existsState", Types.BOOLEAN);
        this.state = ctx.getRuntimeContext().getState(stateDesc);
    }

    @Override
    public BaseRow addInput(@Nullable BaseRow value, BaseRow input) {
        if (value == null) {
            return (BaseRow)this.typeSerializer.copy((Object)input);
        }
        return value;
    }

    @Override
    public void finishBundle(Map<BaseRow, BaseRow> buffer, Collector<BaseRow> out) throws Exception {
        for (Map.Entry<BaseRow, BaseRow> entry : buffer.entrySet()) {
            BaseRow currentKey = entry.getKey();
            BaseRow currentRow = entry.getValue();
            this.ctx.setCurrentKey(currentKey);
            DeduplicateFunctionHelper.processFirstRow(currentRow, this.state, out);
        }
    }
}

