/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.dataformat;

import java.util.Arrays;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.typeinfo.TypeInfo;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.table.dataformat.BinarySection;
import org.apache.flink.table.dataformat.LazyBinaryFormat;
import org.apache.flink.table.runtime.typeutils.BinaryStringTypeInfoFactory;
import org.apache.flink.table.runtime.util.SegmentsUtil;
import org.apache.flink.table.runtime.util.StringUtf8Utils;
import org.apache.flink.util.Preconditions;

@TypeInfo(value=BinaryStringTypeInfoFactory.class)
public final class BinaryString
extends LazyBinaryFormat<String>
implements Comparable<BinaryString> {
    public static final BinaryString EMPTY_UTF8 = BinaryString.fromBytes(StringUtf8Utils.encodeUTF8(""));

    public BinaryString() {
    }

    private BinaryString(MemorySegment[] segments, int offset, int sizeInBytes) {
        super(segments, offset, sizeInBytes);
    }

    private BinaryString(String javaObject) {
        super(javaObject);
    }

    private BinaryString(MemorySegment[] segments, int offset, int sizeInBytes, String javaObject) {
        super(segments, offset, sizeInBytes, javaObject);
    }

    public static BinaryString fromAddress(MemorySegment[] segments, int offset, int numBytes) {
        return new BinaryString(segments, offset, numBytes);
    }

    public static BinaryString fromString(String str) {
        if (str == null) {
            return null;
        }
        return new BinaryString(str);
    }

    public static BinaryString fromBytes(byte[] bytes) {
        return BinaryString.fromBytes(bytes, 0, bytes.length);
    }

    public static BinaryString fromBytes(byte[] bytes, int offset, int numBytes) {
        return new BinaryString(new MemorySegment[]{MemorySegmentFactory.wrap((byte[])bytes)}, offset, numBytes);
    }

    public static BinaryString blankString(int length) {
        byte[] spaces = new byte[length];
        Arrays.fill(spaces, (byte)32);
        return BinaryString.fromBytes(spaces);
    }

    public int numChars() {
        this.ensureMaterialized();
        if (this.inFirstSegment()) {
            int len = 0;
            for (int i = 0; i < this.binarySection.sizeInBytes; i += BinaryString.numBytesForFirstByte(this.getByteOneSegment(i))) {
                ++len;
            }
            return len;
        }
        return this.numCharsMultiSegs();
    }

    private int numCharsMultiSegs() {
        int len = 0;
        int segSize = this.binarySection.segments[0].size();
        SegmentAndOffset index = this.firstSegmentAndOffset(segSize);
        int i = 0;
        while (i < this.binarySection.sizeInBytes) {
            int charBytes = BinaryString.numBytesForFirstByte(index.value());
            i += charBytes;
            ++len;
            index.skipBytes(charBytes, segSize);
        }
        return len;
    }

    public byte byteAt(int index) {
        this.ensureMaterialized();
        int globalOffset = this.binarySection.offset + index;
        int size = this.binarySection.segments[0].size();
        if (globalOffset < size) {
            return this.binarySection.segments[0].get(globalOffset);
        }
        return this.binarySection.segments[globalOffset / size].get(globalOffset % size);
    }

    public byte[] getBytes() {
        this.ensureMaterialized();
        return SegmentsUtil.getBytes(this.binarySection.segments, this.binarySection.offset, this.binarySection.sizeInBytes);
    }

    public boolean equals(Object o) {
        if (o instanceof BinaryString) {
            BinaryString other = (BinaryString)o;
            if (this.javaObject != null && other.javaObject != null) {
                return ((String)this.javaObject).equals(other.javaObject);
            }
            this.ensureMaterialized();
            other.ensureMaterialized();
            return this.binarySection.equals(other.binarySection);
        }
        return false;
    }

    public int hashCode() {
        this.ensureMaterialized();
        return this.binarySection.hashCode();
    }

    public String toString() {
        if (this.javaObject == null) {
            byte[] bytes = SegmentsUtil.allocateReuseBytes(this.binarySection.sizeInBytes);
            SegmentsUtil.copyToBytes(this.binarySection.segments, this.binarySection.offset, bytes, 0, this.binarySection.sizeInBytes);
            this.javaObject = StringUtf8Utils.decodeUTF8(bytes, 0, this.binarySection.sizeInBytes);
        }
        return (String)this.javaObject;
    }

    @Override
    public MemorySegment[] getSegments() {
        this.ensureMaterialized();
        return super.getSegments();
    }

    @Override
    public int getOffset() {
        this.ensureMaterialized();
        return super.getOffset();
    }

    @Override
    public int getSizeInBytes() {
        this.ensureMaterialized();
        return super.getSizeInBytes();
    }

    public void ensureMaterialized() {
        this.ensureMaterialized(null);
    }

    @Override
    protected BinarySection materialize(TypeSerializer<String> serializer) {
        if (serializer != null) {
            throw new IllegalArgumentException("BinaryString does not support custom serializers");
        }
        byte[] bytes = StringUtf8Utils.encodeUTF8((String)this.javaObject);
        return new BinarySection(new MemorySegment[]{MemorySegmentFactory.wrap((byte[])bytes)}, 0, bytes.length);
    }

    public BinaryString copy() {
        this.ensureMaterialized();
        byte[] copy = SegmentsUtil.copyToBytes(this.binarySection.segments, this.binarySection.offset, this.binarySection.sizeInBytes);
        return new BinaryString(new MemorySegment[]{MemorySegmentFactory.wrap((byte[])copy)}, 0, this.binarySection.sizeInBytes, (String)this.javaObject);
    }

    @Override
    public int compareTo(@Nonnull BinaryString other) {
        if (this.javaObject != null && other.javaObject != null) {
            return ((String)this.javaObject).compareTo((String)other.javaObject);
        }
        this.ensureMaterialized();
        other.ensureMaterialized();
        if (this.binarySection.segments.length == 1 && other.binarySection.segments.length == 1) {
            int len = Math.min(this.binarySection.sizeInBytes, other.binarySection.sizeInBytes);
            MemorySegment seg1 = this.binarySection.segments[0];
            MemorySegment seg2 = other.binarySection.segments[0];
            for (int i = 0; i < len; ++i) {
                int res = (seg1.get(this.binarySection.offset + i) & 0xFF) - (seg2.get(other.binarySection.offset + i) & 0xFF);
                if (res == 0) continue;
                return res;
            }
            return this.binarySection.sizeInBytes - other.binarySection.sizeInBytes;
        }
        return this.compareMultiSegments(other);
    }

    private int compareMultiSegments(BinaryString other) {
        int sizeOfFirst1;
        if (this.binarySection.sizeInBytes == 0 || other.binarySection.sizeInBytes == 0) {
            return this.binarySection.sizeInBytes - other.binarySection.sizeInBytes;
        }
        int len = Math.min(this.binarySection.sizeInBytes, other.binarySection.sizeInBytes);
        MemorySegment seg1 = this.binarySection.segments[0];
        MemorySegment seg2 = other.binarySection.segments[0];
        int segmentSize = this.binarySection.segments[0].size();
        int otherSegmentSize = other.binarySection.segments[0].size();
        int sizeOfFirst2 = otherSegmentSize - other.binarySection.offset;
        int varSegIndex1 = 1;
        int varSegIndex2 = 1;
        for (sizeOfFirst1 = segmentSize - this.binarySection.offset; sizeOfFirst1 <= 0; sizeOfFirst1 += segmentSize) {
            seg1 = this.binarySection.segments[varSegIndex1++];
        }
        while (sizeOfFirst2 <= 0) {
            sizeOfFirst2 += otherSegmentSize;
            seg2 = other.binarySection.segments[varSegIndex2++];
        }
        int offset1 = segmentSize - sizeOfFirst1;
        int offset2 = otherSegmentSize - sizeOfFirst2;
        int needCompare = Math.min(Math.min(sizeOfFirst1, sizeOfFirst2), len);
        while (needCompare > 0) {
            for (int i = 0; i < needCompare; ++i) {
                int res = (seg1.get(offset1 + i) & 0xFF) - (seg2.get(offset2 + i) & 0xFF);
                if (res == 0) continue;
                return res;
            }
            if (needCompare == len) break;
            len -= needCompare;
            if (sizeOfFirst1 < sizeOfFirst2) {
                seg1 = this.binarySection.segments[varSegIndex1++];
                offset1 = 0;
                offset2 += needCompare;
                sizeOfFirst1 = segmentSize;
                sizeOfFirst2 -= needCompare;
            } else if (sizeOfFirst1 > sizeOfFirst2) {
                seg2 = other.binarySection.segments[varSegIndex2++];
                offset2 = 0;
                offset1 += needCompare;
                sizeOfFirst2 = otherSegmentSize;
                sizeOfFirst1 -= needCompare;
            } else {
                seg1 = this.binarySection.segments[varSegIndex1++];
                seg2 = other.binarySection.segments[varSegIndex2++];
                offset1 = 0;
                offset2 = 0;
                sizeOfFirst1 = segmentSize;
                sizeOfFirst2 = otherSegmentSize;
            }
            needCompare = Math.min(Math.min(sizeOfFirst1, sizeOfFirst2), len);
        }
        Preconditions.checkArgument((needCompare == len ? 1 : 0) != 0);
        return this.binarySection.sizeInBytes - other.binarySection.sizeInBytes;
    }

    public BinaryString substring(int beginIndex, int endIndex) {
        this.ensureMaterialized();
        if (endIndex <= beginIndex || beginIndex >= this.binarySection.sizeInBytes) {
            return EMPTY_UTF8;
        }
        if (this.inFirstSegment()) {
            int c;
            MemorySegment segment = this.binarySection.segments[0];
            int i = 0;
            for (c = 0; i < this.binarySection.sizeInBytes && c < beginIndex; i += BinaryString.numBytesForFirstByte(segment.get(i + this.binarySection.offset)), ++c) {
            }
            int j = i;
            while (i < this.binarySection.sizeInBytes && c < endIndex) {
                i += BinaryString.numBytesForFirstByte(segment.get(i + this.binarySection.offset));
                ++c;
            }
            if (i > j) {
                byte[] bytes = new byte[i - j];
                segment.get(this.binarySection.offset + j, bytes, 0, i - j);
                return BinaryString.fromBytes(bytes);
            }
            return EMPTY_UTF8;
        }
        return this.substringMultiSegs(beginIndex, endIndex);
    }

    private BinaryString substringMultiSegs(int start, int until) {
        int c;
        int charSize;
        int segSize = this.binarySection.segments[0].size();
        SegmentAndOffset index = this.firstSegmentAndOffset(segSize);
        int i = 0;
        for (c = 0; i < this.binarySection.sizeInBytes && c < start; i += charSize, ++c) {
            charSize = BinaryString.numBytesForFirstByte(index.value());
            index.skipBytes(charSize, segSize);
        }
        int j = i;
        while (i < this.binarySection.sizeInBytes && c < until) {
            int charSize2 = BinaryString.numBytesForFirstByte(index.value());
            i += charSize2;
            index.skipBytes(charSize2, segSize);
            ++c;
        }
        if (i > j) {
            return BinaryString.fromBytes(SegmentsUtil.copyToBytes(this.binarySection.segments, this.binarySection.offset + j, i - j));
        }
        return EMPTY_UTF8;
    }

    public boolean contains(BinaryString s) {
        this.ensureMaterialized();
        s.ensureMaterialized();
        if (s.binarySection.sizeInBytes == 0) {
            return true;
        }
        int find = SegmentsUtil.find(this.binarySection.segments, this.binarySection.offset, this.binarySection.sizeInBytes, s.binarySection.segments, s.binarySection.offset, s.binarySection.sizeInBytes);
        return find != -1;
    }

    public boolean startsWith(BinaryString prefix) {
        this.ensureMaterialized();
        prefix.ensureMaterialized();
        return this.matchAt(prefix, 0);
    }

    public boolean endsWith(BinaryString suffix) {
        this.ensureMaterialized();
        suffix.ensureMaterialized();
        return this.matchAt(suffix, this.binarySection.sizeInBytes - suffix.binarySection.sizeInBytes);
    }

    public BinaryString trim() {
        this.ensureMaterialized();
        if (this.inFirstSegment()) {
            int s;
            int e = this.binarySection.sizeInBytes - 1;
            for (s = 0; s < this.binarySection.sizeInBytes && this.getByteOneSegment(s) == 32; ++s) {
            }
            while (e >= s && this.getByteOneSegment(e) == 32) {
                --e;
            }
            if (s > e) {
                return EMPTY_UTF8;
            }
            return this.copyBinaryStringInOneSeg(s, e - s + 1);
        }
        return this.trimMultiSegs();
    }

    private BinaryString trimMultiSegs() {
        int s;
        int e = this.binarySection.sizeInBytes - 1;
        int segSize = this.binarySection.segments[0].size();
        SegmentAndOffset front = this.firstSegmentAndOffset(segSize);
        for (s = 0; s < this.binarySection.sizeInBytes && front.value() == 32; ++s) {
            front.nextByte(segSize);
        }
        SegmentAndOffset behind = this.lastSegmentAndOffset(segSize);
        while (e >= s && behind.value() == 32) {
            --e;
            behind.previousByte(segSize);
        }
        if (s > e) {
            return EMPTY_UTF8;
        }
        return this.copyBinaryString(s, e);
    }

    public int indexOf(BinaryString str, int fromIndex) {
        this.ensureMaterialized();
        str.ensureMaterialized();
        if (str.binarySection.sizeInBytes == 0) {
            return 0;
        }
        if (this.inFirstSegment()) {
            int charIdx;
            int byteIdx = 0;
            for (charIdx = 0; byteIdx < this.binarySection.sizeInBytes && charIdx < fromIndex; byteIdx += BinaryString.numBytesForFirstByte(this.getByteOneSegment(byteIdx)), ++charIdx) {
            }
            do {
                if (byteIdx + str.binarySection.sizeInBytes > this.binarySection.sizeInBytes) {
                    return -1;
                }
                if (SegmentsUtil.equals(this.binarySection.segments, this.binarySection.offset + byteIdx, str.binarySection.segments, str.binarySection.offset, str.binarySection.sizeInBytes)) {
                    return charIdx;
                }
                byteIdx += BinaryString.numBytesForFirstByte(this.getByteOneSegment(byteIdx));
                ++charIdx;
            } while (byteIdx < this.binarySection.sizeInBytes);
            return -1;
        }
        return this.indexOfMultiSegs(str, fromIndex);
    }

    private int indexOfMultiSegs(BinaryString str, int fromIndex) {
        int charIdx;
        int charBytes;
        int byteIdx = 0;
        int segSize = this.binarySection.segments[0].size();
        SegmentAndOffset index = this.firstSegmentAndOffset(segSize);
        for (charIdx = 0; byteIdx < this.binarySection.sizeInBytes && charIdx < fromIndex; byteIdx += charBytes, ++charIdx) {
            charBytes = BinaryString.numBytesForFirstByte(index.value());
            index.skipBytes(charBytes, segSize);
        }
        do {
            if (byteIdx + str.binarySection.sizeInBytes > this.binarySection.sizeInBytes) {
                return -1;
            }
            if (SegmentsUtil.equals(this.binarySection.segments, this.binarySection.offset + byteIdx, str.binarySection.segments, str.binarySection.offset, str.binarySection.sizeInBytes)) {
                return charIdx;
            }
            charBytes = BinaryString.numBytesForFirstByte(index.segment.get(index.offset));
            ++charIdx;
            index.skipBytes(charBytes, segSize);
        } while ((byteIdx += charBytes) < this.binarySection.sizeInBytes);
        return -1;
    }

    public BinaryString toUpperCase() {
        if (this.javaObject != null) {
            return this.javaToUpperCase();
        }
        if (this.binarySection.sizeInBytes == 0) {
            return EMPTY_UTF8;
        }
        int size = this.binarySection.segments[0].size();
        SegmentAndOffset segmentAndOffset = this.startSegmentAndOffset(size);
        byte[] bytes = new byte[this.binarySection.sizeInBytes];
        bytes[0] = (byte)Character.toTitleCase(segmentAndOffset.value());
        for (int i = 0; i < this.binarySection.sizeInBytes; ++i) {
            byte b = segmentAndOffset.value();
            if (BinaryString.numBytesForFirstByte(b) != 1) {
                return this.javaToUpperCase();
            }
            int upper = Character.toUpperCase(b);
            if (upper > 127) {
                return this.javaToUpperCase();
            }
            bytes[i] = (byte)upper;
            segmentAndOffset.nextByte(size);
        }
        return BinaryString.fromBytes(bytes);
    }

    private BinaryString javaToUpperCase() {
        return BinaryString.fromString(this.toString().toUpperCase());
    }

    public BinaryString toLowerCase() {
        if (this.javaObject != null) {
            return this.javaToLowerCase();
        }
        if (this.binarySection.sizeInBytes == 0) {
            return EMPTY_UTF8;
        }
        int size = this.binarySection.segments[0].size();
        SegmentAndOffset segmentAndOffset = this.startSegmentAndOffset(size);
        byte[] bytes = new byte[this.binarySection.sizeInBytes];
        bytes[0] = (byte)Character.toTitleCase(segmentAndOffset.value());
        for (int i = 0; i < this.binarySection.sizeInBytes; ++i) {
            byte b = segmentAndOffset.value();
            if (BinaryString.numBytesForFirstByte(b) != 1) {
                return this.javaToLowerCase();
            }
            int lower = Character.toLowerCase(b);
            if (lower > 127) {
                return this.javaToLowerCase();
            }
            bytes[i] = (byte)lower;
            segmentAndOffset.nextByte(size);
        }
        return BinaryString.fromBytes(bytes);
    }

    private BinaryString javaToLowerCase() {
        return BinaryString.fromString(this.toString().toLowerCase());
    }

    byte getByteOneSegment(int i) {
        return this.binarySection.segments[0].get(this.binarySection.offset + i);
    }

    boolean inFirstSegment() {
        return this.binarySection.sizeInBytes + this.binarySection.offset <= this.binarySection.segments[0].size();
    }

    private boolean matchAt(BinaryString s, int pos) {
        return this.inFirstSegment() && s.inFirstSegment() ? this.matchAtOneSeg(s, pos) : this.matchAtVarSeg(s, pos);
    }

    private boolean matchAtOneSeg(BinaryString s, int pos) {
        return s.binarySection.sizeInBytes + pos <= this.binarySection.sizeInBytes && pos >= 0 && this.binarySection.segments[0].equalTo(s.binarySection.segments[0], this.binarySection.offset + pos, s.binarySection.offset, s.binarySection.sizeInBytes);
    }

    private boolean matchAtVarSeg(BinaryString s, int pos) {
        return s.binarySection.sizeInBytes + pos <= this.binarySection.sizeInBytes && pos >= 0 && SegmentsUtil.equals(this.binarySection.segments, this.binarySection.offset + pos, s.binarySection.segments, s.binarySection.offset, s.binarySection.sizeInBytes);
    }

    BinaryString copyBinaryStringInOneSeg(int start, int len) {
        byte[] newBytes = new byte[len];
        this.binarySection.segments[0].get(this.binarySection.offset + start, newBytes, 0, len);
        return BinaryString.fromBytes(newBytes);
    }

    BinaryString copyBinaryString(int start, int end) {
        int len = end - start + 1;
        byte[] newBytes = new byte[len];
        SegmentsUtil.copyToBytes(this.binarySection.segments, this.binarySection.offset + start, newBytes, 0, len);
        return BinaryString.fromBytes(newBytes);
    }

    SegmentAndOffset firstSegmentAndOffset(int segSize) {
        int segIndex = this.binarySection.offset / segSize;
        return new SegmentAndOffset(segIndex, this.binarySection.offset % segSize);
    }

    SegmentAndOffset lastSegmentAndOffset(int segSize) {
        int lastOffset = this.binarySection.offset + this.binarySection.sizeInBytes - 1;
        int segIndex = lastOffset / segSize;
        return new SegmentAndOffset(segIndex, lastOffset % segSize);
    }

    private SegmentAndOffset startSegmentAndOffset(int segSize) {
        return this.inFirstSegment() ? new SegmentAndOffset(0, this.binarySection.offset) : this.firstSegmentAndOffset(segSize);
    }

    static int numBytesForFirstByte(byte b) {
        if (b >= 0) {
            return 1;
        }
        if (b >> 5 == -2 && (b & 0x1E) != 0) {
            return 2;
        }
        if (b >> 4 == -2) {
            return 3;
        }
        if (b >> 3 == -2) {
            return 4;
        }
        return 1;
    }

    class SegmentAndOffset {
        int segIndex;
        MemorySegment segment;
        int offset;

        private SegmentAndOffset(int segIndex, int offset) {
            this.segIndex = segIndex;
            this.segment = BinaryString.this.binarySection.segments[segIndex];
            this.offset = offset;
        }

        private void assignSegment() {
            this.segment = this.segIndex >= 0 && this.segIndex < BinaryString.this.binarySection.segments.length ? BinaryString.this.binarySection.segments[this.segIndex] : null;
        }

        void previousByte(int segSize) {
            --this.offset;
            if (this.offset == -1) {
                --this.segIndex;
                this.assignSegment();
                this.offset = segSize - 1;
            }
        }

        void nextByte(int segSize) {
            ++this.offset;
            this.checkAdvance(segSize);
        }

        private void checkAdvance(int segSize) {
            if (this.offset == segSize) {
                this.advance();
            }
        }

        private void advance() {
            ++this.segIndex;
            this.assignSegment();
            this.offset = 0;
        }

        void skipBytes(int n, int segSize) {
            int remaining = segSize - this.offset;
            if (remaining > n) {
                this.offset += n;
            } else {
                while (true) {
                    int toSkip;
                    if ((n -= (toSkip = Math.min(remaining, n))) <= 0) {
                        this.offset += toSkip;
                        this.checkAdvance(segSize);
                        return;
                    }
                    this.advance();
                    remaining = segSize - this.offset;
                }
            }
        }

        byte value() {
            return this.segment.get(this.offset);
        }
    }
}

