/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.aggregate.window.combines;

import java.time.ZoneId;
import java.util.Iterator;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.runtime.state.KeyedStateBackend;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.util.RowDataUtil;
import org.apache.flink.table.runtime.dataview.PerWindowStateDataViewStore;
import org.apache.flink.table.runtime.generated.GeneratedNamespaceAggsHandleFunction;
import org.apache.flink.table.runtime.generated.NamespaceAggsHandleFunction;
import org.apache.flink.table.runtime.operators.window.combines.WindowCombineFunction;
import org.apache.flink.table.runtime.operators.window.slicing.WindowTimerService;
import org.apache.flink.table.runtime.operators.window.state.StateKeyContext;
import org.apache.flink.table.runtime.operators.window.state.WindowState;
import org.apache.flink.table.runtime.operators.window.state.WindowValueState;
import org.apache.flink.table.runtime.util.StateConfigUtil;
import org.apache.flink.table.runtime.util.TimeWindowUtil;
import org.apache.flink.table.runtime.util.WindowKey;

public final class AggRecordsCombiner
implements WindowCombineFunction {
    private final WindowTimerService<Long> timerService;
    private final StateKeyContext keyContext;
    private final WindowValueState<Long> accState;
    private final NamespaceAggsHandleFunction<Long> aggregator;
    private final boolean requiresCopy;
    private final TypeSerializer<RowData> keySerializer;
    private final TypeSerializer<RowData> recordSerializer;
    private final boolean isEventTime;

    public AggRecordsCombiner(WindowTimerService<Long> timerService, StateKeyContext keyContext, WindowValueState<Long> accState, NamespaceAggsHandleFunction<Long> aggregator, boolean requiresCopy, TypeSerializer<RowData> keySerializer, TypeSerializer<RowData> recordSerializer, boolean isEventTime) {
        this.timerService = timerService;
        this.keyContext = keyContext;
        this.accState = accState;
        this.aggregator = aggregator;
        this.requiresCopy = requiresCopy;
        this.keySerializer = keySerializer;
        this.recordSerializer = recordSerializer;
        this.isEventTime = isEventTime;
    }

    @Override
    public void combine(WindowKey windowKey, Iterator<RowData> records) throws Exception {
        RowData key = this.requiresCopy ? (RowData)this.keySerializer.copy((Object)windowKey.getKey()) : windowKey.getKey();
        this.keyContext.setCurrentKey(key);
        Long window = windowKey.getWindow();
        RowData acc = this.accState.value(window);
        if (acc == null) {
            acc = this.aggregator.createAccumulators();
        }
        this.aggregator.setAccumulators(window, acc);
        while (records.hasNext()) {
            RowData record = records.next();
            if (this.requiresCopy) {
                record = (RowData)this.recordSerializer.copy((Object)record);
            }
            if (RowDataUtil.isAccumulateMsg(record)) {
                this.aggregator.accumulate(record);
                continue;
            }
            this.aggregator.retract(record);
        }
        acc = this.aggregator.getAccumulators();
        this.accState.update(window, acc);
        if (this.isEventTime) {
            long currentWatermark = this.timerService.currentWatermark();
            ZoneId shiftTimeZone = this.timerService.getShiftTimeZone();
            if (!TimeWindowUtil.isWindowFired(window, currentWatermark, shiftTimeZone)) {
                this.timerService.registerEventTimeWindowTimer(window);
            }
        }
    }

    @Override
    public void close() throws Exception {
        this.aggregator.close();
    }

    public static final class Factory
    implements WindowCombineFunction.Factory {
        private static final long serialVersionUID = 1L;
        private final GeneratedNamespaceAggsHandleFunction<Long> genAggsHandler;
        private final TypeSerializer<RowData> keySerializer;
        private final TypeSerializer<RowData> recordSerializer;

        public Factory(GeneratedNamespaceAggsHandleFunction<Long> genAggsHandler, TypeSerializer<RowData> keySerializer, TypeSerializer<RowData> recordSerializer) {
            this.genAggsHandler = genAggsHandler;
            this.keySerializer = keySerializer;
            this.recordSerializer = recordSerializer;
        }

        @Override
        public WindowCombineFunction create(RuntimeContext runtimeContext, WindowTimerService<Long> timerService, KeyedStateBackend<RowData> stateBackend, WindowState<Long> windowState, boolean isEventTime) throws Exception {
            NamespaceAggsHandleFunction aggregator = (NamespaceAggsHandleFunction)this.genAggsHandler.newInstance(runtimeContext.getUserCodeClassLoader());
            aggregator.open(new PerWindowStateDataViewStore(stateBackend, (TypeSerializer<?>)LongSerializer.INSTANCE, runtimeContext));
            boolean requiresCopy = !StateConfigUtil.isStateImmutableInStateBackend(stateBackend);
            WindowValueState windowValueState = (WindowValueState)windowState;
            return new AggRecordsCombiner(timerService, arg_0 -> stateBackend.setCurrentKey(arg_0), windowValueState, aggregator, requiresCopy, this.keySerializer, this.recordSerializer, isEventTime);
        }
    }
}

