/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.common;

import java.time.ZoneId;
import java.util.List;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.logical.TimeAttributeWindowingStrategy;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.SingleTransformationTranslator;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodeUtil;
import org.apache.flink.table.planner.plan.utils.WindowTableFunctionUtil;
import org.apache.flink.table.planner.utils.TableConfigUtils;
import org.apache.flink.table.runtime.operators.window.TimeWindow;
import org.apache.flink.table.runtime.operators.window.WindowTableFunctionOperator;
import org.apache.flink.table.runtime.operators.window.assigners.WindowAssigner;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.runtime.util.TimeWindowUtil;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

public abstract class CommonExecWindowTableFunction
extends ExecNodeBase<RowData>
implements BatchExecNode<RowData>,
SingleTransformationTranslator<RowData> {
    public static final String WINDOW_TRANSFORMATION = "window";
    public static final String FIELD_NAME_WINDOWING = "windowing";
    @JsonProperty(value="windowing")
    protected final TimeAttributeWindowingStrategy windowingStrategy;

    protected CommonExecWindowTableFunction(int id, ExecNodeContext context, ReadableConfig persistedConfig, TimeAttributeWindowingStrategy windowingStrategy, List<InputProperty> inputProperties, RowType outputType, String description) {
        super(id, context, persistedConfig, inputProperties, (LogicalType)outputType, description);
        Preconditions.checkArgument((inputProperties.size() == 1 ? 1 : 0) != 0);
        this.windowingStrategy = (TimeAttributeWindowingStrategy)Preconditions.checkNotNull((Object)windowingStrategy);
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner, ExecNodeConfig config) {
        ExecEdge inputEdge = this.getInputEdges().get(0);
        Transformation<?> inputTransform = inputEdge.translateToPlan(planner);
        WindowAssigner<TimeWindow> windowAssigner = WindowTableFunctionUtil.createWindowAssigner(this.windowingStrategy);
        ZoneId shiftTimeZone = TimeWindowUtil.getShiftTimeZone((LogicalType)this.windowingStrategy.getTimeAttributeType(), (ZoneId)TableConfigUtils.getLocalTimeZone(config));
        WindowTableFunctionOperator windowTableFunctionOperator = new WindowTableFunctionOperator(windowAssigner, this.windowingStrategy.getTimeAttributeIndex(), shiftTimeZone);
        return ExecNodeUtil.createOneInputTransformation(inputTransform, this.createTransformationMeta(WINDOW_TRANSFORMATION, config), windowTableFunctionOperator, InternalTypeInfo.of((LogicalType)this.getOutputType()), inputTransform.getParallelism());
    }
}

