/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec;

import java.time.Duration;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.config.ExecutionConfigOptions;

@Internal
public final class ExecNodeConfig
implements ReadableConfig {
    private final TableConfig tableConfig;
    private final ReadableConfig nodeConfig;

    ExecNodeConfig(TableConfig tableConfig, ReadableConfig nodeConfig) {
        this.nodeConfig = nodeConfig;
        this.tableConfig = tableConfig;
    }

    @Deprecated
    public TableConfig getTableConfig() {
        return this.tableConfig;
    }

    public <T> T get(ConfigOption<T> option) {
        return (T)this.nodeConfig.getOptional(option).orElseGet(() -> this.tableConfig.get(option));
    }

    public <T> Optional<T> getOptional(ConfigOption<T> option) {
        Optional tableValue = this.nodeConfig.getOptional(option);
        if (tableValue.isPresent()) {
            return tableValue;
        }
        return this.tableConfig.getOptional(option);
    }

    public long getStateRetentionTime() {
        return ((Duration)this.get(ExecutionConfigOptions.IDLE_STATE_RETENTION)).toMillis();
    }
}

