/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions.converter.converters;

import java.util.LinkedList;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlJsonConstructorNullClause;
import org.apache.calcite.sql.SqlOperator;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.planner.expressions.converter.CallExpressionConvertRule;
import org.apache.flink.table.planner.expressions.converter.converters.CustomizedConverter;
import org.apache.flink.table.planner.expressions.converter.converters.JsonConverterUtil;
import org.apache.flink.table.planner.functions.sql.FlinkSqlOperatorTable;

@Internal
class JsonArrayConverter
extends CustomizedConverter {
    JsonArrayConverter() {
    }

    @Override
    public RexNode convert(CallExpression call, CallExpressionConvertRule.ConvertContext context) {
        JsonArrayConverter.checkArgument(call, call.getChildren().size() >= 1);
        LinkedList<RexNode> operands = new LinkedList<RexNode>();
        SqlJsonConstructorNullClause onNull = JsonConverterUtil.getOnNullArgument(call, 0);
        operands.add(context.getRelBuilder().getRexBuilder().makeFlag(onNull));
        for (int i = 1; i < call.getChildren().size(); ++i) {
            operands.add(context.toRexNode((Expression)call.getChildren().get(i)));
        }
        return context.getRelBuilder().getRexBuilder().makeCall((SqlOperator)FlinkSqlOperatorTable.JSON_ARRAY, operands);
    }
}

